core.register_craftitem("stoneage:silex", {
	description = "Silex",
	inventory_image = "stoneage_silex.png",
})

-----------------------------------------------------------------------------------------------
--	Bone
-----------------------------------------------------------------------------------------------
core.register_craftitem("stoneage:gnawed_bone", {
	description = "Bone",
	inventory_image = "gnawedbones_bone.png",
})

local heal_1 = function(itemstack, user, pointed_thing)
	local inv = user:get_inventory()
	local heal = user:get_hp() + 1
	user:set_hp(heal)
	itemstack:take_item()
	if inv:room_for_item("main", { name = "stoneage:gnawed_bone", count = 1, wear = 0, metadata = "" }) then
		inv:add_item("main", { name = "stoneage:gnawed_bone", count = 1, wear = 0, metadata = "" })
	end
	return itemstack
end

local heal_3 = function(itemstack, user, pointed_thing)
	local inv = user:get_inventory()
	local heal = user:get_hp() + 3
	user:set_hp(heal)
	itemstack:take_item()
	if inv:room_for_item("main", { name = "stoneage:gnawed_bone", count = 1, wear = 0, metadata = "" }) then
		inv:add_item("main", { name = "stoneage:gnawed_bone", count = 1, wear = 0, metadata = "" })
	end
	return itemstack
end

-----------------------------------------------------------------------------------------------
-- Old items (legacy)
-----------------------------------------------------------------------------------------------
-- Rat
core.register_craftitem(":rat", {
	description = "Rat",
	inventory_image = "rat.png",
	on_use = heal_3,
})
-- Cooked Rat
core.register_craftitem(":cooked_rat", {
	description = "Cooked rat",
	inventory_image = "cooked_rat.png",
	on_use = function(itemstack, user, pointed_thing)
		local inv = user:get_inventory()
		local heal = user:get_hp() + 6
		user:set_hp(heal)
		itemstack:take_item()
		if inv:room_for_item("main", { name = "stoneage:gnawed_bone", count = 1, wear = 0, metadata = "" }) then
			inv:add_item("main", { name = "stoneage:gnawed_bone", count = 1, wear = 0, metadata = "" })
		end
		return itemstack
	end,
})

-----------------------------------------------------------------------------------------------
-- Simple Mobs
-----------------------------------------------------------------------------------------------

if core.global_exists("mobs") then
	-- Raw Meat
	core.register_craftitem(":mobs:meat_raw", {
		description = "Raw Meat",
		inventory_image = "mobs_meat_raw.png",
		on_use = function(itemstack, user, pointed_thing)
			local inv = user:get_inventory()
			local heal = user:get_hp() + 4
			user:set_hp(heal)
			itemstack:take_item()
			if inv:room_for_item("main", { name = "stoneage:gnawed_bone", count = 1, wear = 0, metadata = "" }) then
				inv:add_item("main", { name = "stoneage:gnawed_bone", count = 1, wear = 0, metadata = "" })
			end
			return itemstack
		end,
	})
	-- Meat
	core.register_craftitem(":mobs:meat", {
		description = "Meat",
		inventory_image = "mobs_meat.png",
		on_use = function(itemstack, user, pointed_thing)
			local inv = user:get_inventory()
			local heal = user:get_hp() + 8
			user:set_hp(heal)
			itemstack:take_item()
			if inv:room_for_item("main", { name = "stoneage:gnawed_bone", count = 1, wear = 0, metadata = "" }) then
				inv:add_item("main", { name = "stoneage:gnawed_bone", count = 1, wear = 0, metadata = "" })
			end
			return itemstack
		end,
	})
	-- Rat
	core.register_craftitem(":mobs:rat", {
		description = "Rat",
		inventory_image = "mobs_rat_inventory.png",
		on_use = heal_1,
		on_place = function(itemstack, placer, pointed_thing)
			if pointed_thing.above then
				core.add_entity(pointed_thing.above, "mobs:rat")
				itemstack:take_item()
			end
			return itemstack
		end,
	})
	-- Cooked Rat	
	core.register_craftitem(":mobs:rat_cooked", {
		description = "Cooked Rat",
		inventory_image = "mobs_cooked_rat.png",
		on_use = heal_3,
	})
end
