--
-- overwrite nodes and tools
--

core.register_on_mods_loaded(function()
	if core.registered_tools['default:pick_stone'] then
		-- core.clear_craft({ output = 'default:pick_stone' })
		core.register_alias_force('default:pick_stone', 'stoneage:pick_bone')
	end

	if core.registered_tools['default:pick_wood'] then
		-- core.clear_craft({ output = 'default:pick_wood' })
		core.register_alias_force('default:pick_wood', 'stoneage:mattock_wood')
	end

	if core.registered_tools['default:shovel_wood'] then
		-- core.clear_craft({ output = 'default:shovel_wood' })
		core.register_alias_force('default:shovel_wood', 'stoneage:mattock_wood')
	end

	if core.registered_tools['default:sword_stone'] then
		-- core.clear_craft({ output = 'default:sword_stone' })
		core.register_alias_force('default:sword_stone', 'stoneage:biface')
	end

	if core.registered_tools['default:sword_wood'] then
		-- core.clear_craft({ output = 'default:sword_wood' })
		core.register_alias_force('default:sword_wood', 'stoneage:club_wood')
	end

	if core.registered_tools['default:axe_stone'] then
		-- core.clear_craft({ output = 'default:axe_stone' })
		core.register_alias_force('default:axe_stone', 'stoneage:biface')
	end

	if core.registered_tools['default:shovel_stone'] then
		core.register_alias_force('default:shovel_stone', 'stoneage:shovel_bone')
	end

	if core.registered_items['default:flint'] then
		core.register_alias_force('default:flint', 'stoneage:silex')
	end

	if core.registered_items['fire:flint_and_steel'] then
		core.register_alias_force('fire:flint_and_steel', 'stoneage:firestriker_steel')
		core.register_alias("stoneage:fire_striker", "stoneage:firestriker_steel")
	end

	if core.global_exists('farming') then
		core.register_alias_force('farming:hoe_wood', 'stoneage:digging_stick')
		core.register_alias('stoneage:hoe_wood', 'stoneage:digging_stick')
	end

	if core.global_exists('spears_register_spear') then
		core.register_alias_force('spears:spear_stone', 'spears:spear_silex')
	end

	local trees = {}
	for node_name, def in pairs(core.registered_nodes) do
		if def.groups then
			if def.groups.tree then
				table.insert(trees, node_name)
				-- elseif def.groups.sand then
				-- 	table.insert(trees, node_name)
			end
		end
	end

	for _, name in ipairs(trees) do
		if core.registered_items[name] then
			local groups = core.registered_items[name].groups
			groups.tree = 1
			groups.choppy = 2
			groups.flammable = 2
			core.override_item(name, { groups = groups })
		end
	end
end)

-- local trees = {
-- 	"default:tree",
-- 	"default:jungletree",
-- 	"moretrees:beech_trunk",
-- 	"moretrees:apple_tree_trunk",
-- 	"moretrees:oak_trunk",
-- 	"moretrees:sequoia_trunk",
-- 	"moretrees:birch_trunk",
-- 	"moretrees:palm_trunk",
-- 	"moretrees:spruce_trunk",
-- 	"moretrees:pine_trunk",
-- 	"moretrees:willow_trunk",
-- 	"moretrees:rubber_tree_trunk",
-- 	"moretrees:jungletree_trunk",
-- 	"moretrees:fir_trunk",
-- 	"conifers:trunk",
-- 	"conifers:trunk_reversed",
-- }

-- for _, name in ipairs(trees) do
-- 	if core.registered_items[name] then
-- 		local groups = { tree = 1, choppy = 2, flammable = 2 }
-- 		core.override_item(name, { groups = groups })
-- 	end
-- end

-- replace, just in case bones from animalmaterials and/or bone are in inventory/world and mod(s) disabled/deinstalled
core.register_alias_force("bone:bone", "stoneage:gnawed_bone")
core.register_alias_force("animalmaterials:bone", "stoneage:gnawed_bone")
