--
-- overwrite nodes and tools
--

if core.global_exists('default') then
	if core.registered_tools['default:pick_stone'] then
		-- core.clear_craft({ output = 'default:pick_stone' })
		core.register_alias_force('default:pick_stone', 'stoneage:pick_bone')
	end

	if core.registered_tools['default:pick_wood'] then
		-- core.clear_craft({ output = 'default:pick_wood' })
		core.register_alias_force('default:pick_wood', 'stoneage:mattock_wood')
	end

	if core.registered_tools['default:shovel_wood'] then
		-- core.clear_craft({ output = 'default:shovel_wood' })
		core.register_alias_force('default:shovel_wood', 'stoneage:mattock_wood')
	end

	if core.registered_tools['default:axe_wood'] then
		-- core.clear_craft({ output = 'default:axe_stone' })
		core.register_alias_force('default:axe_wood', 'stoneage:mattock_wood')
	end

	if core.registered_tools['default:sword_stone'] then
		-- core.clear_craft({ output = 'default:sword_stone' })
		core.register_alias_force('default:sword_stone', 'stoneage:biface')
	end

	if core.registered_tools['default:sword_wood'] then
		-- core.clear_craft({ output = 'default:sword_wood' })
		core.register_alias_force('default:sword_wood', 'stoneage:club_wood')
	end

	if core.registered_tools['default:axe_stone'] then
		-- core.clear_craft({ output = 'default:axe_stone' })
		core.register_alias_force('default:axe_stone', 'stoneage:biface')
	end

	if core.registered_tools['default:shovel_stone'] then
		core.register_alias_force('default:shovel_stone', 'stoneage:shovel_bone')
	end

	if core.registered_items['default:flint'] then
		core.register_alias_force('default:flint', 'stoneage:silex')
	end
end
if core.registered_items['fire:flint_and_steel'] then
	core.register_alias_force('fire:flint_and_steel', 'stoneage:firestriker_steel')
	core.register_alias("stoneage:fire_striker", "stoneage:firestriker_steel")
end

if core.global_exists('farming') then
	core.register_alias_force('farming:hoe_wood', 'stoneage:digging_stick')
	core.register_alias('stoneage:hoe_wood', 'stoneage:digging_stick')
end

if core.global_exists('spears_register_spear') then
	core.register_alias_force('spears:spear_stone', 'spears:spear_silex')
end

	core.register_on_mods_loaded(function()

	local trees = {}
	for node_name, def in pairs(core.registered_nodes) do
		if def.groups then
			if def.groups.tree then
				table.insert(trees, node_name)
				-- elseif def.groups.sand then
				-- 	table.insert(trees, node_name)
			end
		end
	end

	for _, name in ipairs(trees) do
		if core.registered_items[name] then
			local groups = core.registered_items[name].groups
			groups.tree = 1
			groups.choppy = 2
			groups.flammable = 2
			core.override_item(name, { groups = groups })
		end
	end
end)

-- local trees = {
-- 	"default:tree",
-- 	"default:jungletree",
-- 	"moretrees:beech_trunk",
-- 	"moretrees:apple_tree_trunk",
-- 	"moretrees:oak_trunk",
-- 	"moretrees:sequoia_trunk",
-- 	"moretrees:birch_trunk",
-- 	"moretrees:palm_trunk",
-- 	"moretrees:spruce_trunk",
-- 	"moretrees:pine_trunk",
-- 	"moretrees:willow_trunk",
-- 	"moretrees:rubber_tree_trunk",
-- 	"moretrees:jungletree_trunk",
-- 	"moretrees:fir_trunk",
-- 	"conifers:trunk",
-- 	"conifers:trunk_reversed",
-- }

-- for _, name in ipairs(trees) do
-- 	if core.registered_items[name] then
-- 		local groups = { tree = 1, choppy = 2, flammable = 2 }
-- 		core.override_item(name, { groups = groups })
-- 	end
-- end

-- replace, just in case bones from animalmaterials and/or bone are in inventory/world and mod(s) disabled/deinstalled
core.register_alias_force("bone:bone", "stoneage:gnawed_bone")
core.register_alias_force("animalmaterials:bone", "stoneage:gnawed_bone")

local meat_with_bone = {
	-- mobs redo
	"mobs:meat_raw", "mobs:meat", "mobs:rat", "mobs:rat_cooked",
	-- mcl_mobitems, i.e. Voxelibre, Mineclonia
	"mcl_mobitems:mutton", "mcl_mobitems:cooked_mutton", "mcl_mobitems:beef", "mcl_mobitems:cooked_beef",
	"mcl_mobitems:chicken", "mcl_mobitems:cooked_chicken", "mcl_mobitems:porkchop",
	"mcl_mobitems:cooked_porkchop", "mcl_mobitems:rabbit", "mcl_mobitems:cooked_rabbit",
	-- animalia
	"animalia:beef_raw", "animalia:beef_cooked", "animalia:mutton_raw", "animalia:mutton_cooked",
	"animalia:rat_raw", "animalia:rat_cooked", "animalia:porkchop_raw", "animalia:porkchop_cooked",
	"animalia:poultry_raw", "animalia:poultry_cooked", "animalia:venison_raw", "animalia:venison_cooked"
}

local meat_set = {}
for _, l in ipairs(meat_with_bone) do meat_set[l] = true end

core.register_on_item_eat(function(hp_change, replace_with_item, itemstack, user, pointed_thing)
    local name = itemstack:get_name()
    if meat_set[name] then
        local inv = user:get_inventory()
		if inv:room_for_item("main", { name = "stoneage:gnawed_bone", count = 1, wear = 0, metadata = "" }) then
			inv:add_item("main", { name = "stoneage:gnawed_bone", count = 1, wear = 0, metadata = "" })
		end
    end
end)
