core.register_tool("stoneage:biface", {
	description = "Biface",
	inventory_image = "stoneage_biface.png",
	tool_capabilities = {
		max_drop_level = 0,
		groupcaps = {
			choppy = { times = { [1] = 3.20, [2] = 1.20, [3] = 0.60 }, uses = 20, maxlevel = 1 },
			fleshy = { times = { [2] = 1.00, [3] = 0.60 }, uses = 30, maxlevel = 1 },
			crumbly = { times = { [1] = 1.70, [2] = 0.70, [3] = 0.50 }, uses = 10, maxlevel = 1 },
			oddly_breakable_by_hand = { times = { [1] = 3.50, [2] = 2.00, [3] = 0.70 }, uses = 0, maxlevel = 3 },
		},
		damage_groups = { fleshy = 2 },
	},
	sounds = xcompat.sounds.node_sound_stone_defaults(),
	groups = { shovel = 1, sword = 1, axe = 1 }
})

-----------------------------------------------------------------------------------------------
-- Stone Pick -> Antler Pick
-----------------------------------------------------------------------------------------------
core.register_tool("stoneage:pick_bone", {
	description = "Deer Antler Pickaxe",
	inventory_image = "archaetools_antlerpick.png",
	tool_capabilities = {
		full_punch_interval = 1.2,
		max_drop_level = 0,
		groupcaps = {
			cracky = { times = { [3] = 1.60 }, uses = 10, maxlevel = 1 },
		},
		damage_groups = { fleshy = 2 },
	},
	sounds = xcompat.sounds.node_sound_stone_defaults(),
	groups = { pickaxe = 1 }
})

-----------------------------------------------------------------------------------------------
-- Wooden Pick, Shovel -> Mattock
-----------------------------------------------------------------------------------------------
core.register_tool("stoneage:mattock_wood", {
	description = "Wood Pick Mattock",
	inventory_image = "woodmattock.png",
	tool_capabilities = {
		max_drop_level = 0,
		groupcaps = {
			cracky = { times = { [2] = 1.00 }, uses = 30, maxlevel = 1 },
			crumbly = { times = { [2] = 0.70 }, uses = 10, maxlevel = 1 },
		},
		damage_groups = { cracky = 2, crumbly = 2 }
	},
	sounds = xcompat.sounds.node_sound_wood_defaults(),
	groups = { shovel = 1, pickaxe = 1, flammable = 2 }
})

-----------------------------------------------------------------------------------------------
-- Stone Shovel -> Bone Shovel
-----------------------------------------------------------------------------------------------
core.register_tool("stoneage:shovel_bone", {
	description = "Bone Shovel",
	inventory_image = "archaetools_boneshovel.png",
	wield_image = "archaetools_boneshovel.png^[transformFX",
	tool_capabilities = {
		full_punch_interval = 1.2,
		max_drop_level = 0,
		groupcaps = {
			crumbly = { times = { [1] = 3.00, [2] = 1.60, [3] = 0.60 }, uses = 10, maxlevel = 1 },
		},
		damage_groups = { fleshy = 2 },
	},
	sounds = xcompat.sounds.node_sound_stone_defaults(),
	groups = { shovel = 1 }
})

-----------------------------------------------------------------------------------------------
-- Wooden Sword -> Club
-----------------------------------------------------------------------------------------------
core.register_tool("stoneage:club_wood", {
	description = "Club",
	inventory_image = "archaetools_woodclub.png",
	tool_capabilities = {
		full_punch_interval = 1.0,
		max_drop_level = 0,
		groupcaps = {
			choppy = { times = { [3] = 0.80 }, uses = 10, maxlevel = 1 },
			fleshy = { times = { [2] = 1.50, [3] = 0.80 }, uses = 10, maxlevel = 1 },
			snappy = { times = { [2] = 1.6, [3] = 0.40 }, uses = 10, maxlevel = 1 },
		},
		damage_groups = { fleshy = 2 },
	},
	sounds = xcompat.sounds.node_sound_wood_defaults(),
	groups = { sword = 1, flammable = 2 }
})

-----------------------------------------------------------------------------------------------
-- Wooden Hoe -> Digging Stick
-----------------------------------------------------------------------------------------------
if core.global_exists('farming') then
	farming.register_hoe(":stoneage:digging_stick", {
		description = "Digging Stick",
		inventory_image = "archaetools_wooddigstick.png",
		max_uses = 30,
		material = "group:wood",
		groups = { hoe = 1, flammable = 2 },
	})

	core.override_item("stoneage:digging_stick", {
		wield_image = "archaetools_wooddigstick.png^[transformFX"
	})
end

if core.global_exists('spears_register_spear') then
	spears_register_spear('bone', 'Bone Spear', 4, 15, ':stoneage:bone')
	spears_register_spear('silex', 'Silex Spear', 3, 20, ':stoneage:silex')
end

core.register_tool("stoneage:firestriker_stone", {
	groups = { igniter = 1 },
	description = "Fire Striker",
	inventory_image = "stoneage_firestriker_stone.png",
	on_use = function(itemstack, user, pointed_thing)
		stoneage.strike_fire(user, pointed_thing)
		itemstack:add_wear(65535 / 16)
		return itemstack
	end,
	sounds = xcompat.sounds.node_sound_stone_defaults()
})

core.register_tool("stoneage:firestriker_steel", {
	groups = { igniter = 1 },
	description = "Fire Striker",
	inventory_image = "stoneage_firestriker_steel.png",
	on_use = function(itemstack, user, pointed_thing)
		stoneage.strike_fire(user, pointed_thing)
		itemstack:add_wear(65535 / 64)
		return itemstack
	end,
	sounds = xcompat.sounds.node_sound_metal_defaults()
})
