# API

## `thermometer.temp_nodes`

Items matching the keys of `thermometer.temp_nodes` (either groups or item names) influence the local temperature depending on the `add` and `rad` (radius) fields, stored in groups `tempsurvive_add` and `tempsurvive_rad`, respectively. The tempsurvive functions calculate the temperature by adding together a calculated temperature of the area plus the values of `add` of nodes in the area plus the `add` value divided by its distance if its within the radius set by `rad`. If the y pos is less than -50, the temperature of the area is 0 deg C.

The overriding to add this functionality occurs after mods have loaded, so your mod can depend on `thermometer` and added items to `thermometer.temp_nodes` via `thermometer.temp_nodes['example:chest'] = { add = 2, rad = 3 }`. You can also add groups to this table via `thermometer.temp_nodes['snowy'] = { add = -1, rad = 2 }`.

`add` should be a positive integer to increase the temperature, and should be a negative integer to decrease the temperature.

## `thermometer.storage_nodes`

Inventories can have similarly calculated temperatures. The raw value (in Celsius) is stored in the metadata under the key `inv_temp`, regardless of the presence of the thermometer. The temperature (with the thermometer if present) is updated on inventory actions. The player inventory and any items in `thermometer.storage_nodes` will have this behavior. By default, thermometer.storage_nodes contains 'default:chest', 'default:locked_chest' and their '_open' varieties.

The overriding to add this functionality occurs after mods have loaded, so your mod can depend on `thermometer` and added nodes to `thermometer.storage_nodes` via `table.insert(thermometer.storage_nodes, 'example:chest')`. If your chest has an open variety like 'default:chest' does, be sure to add that variation to this table as well.

## `thermometer.getTemp(pos)`

Use this function to get the temperature at the given position. This calls `tempsurvive.get_bio_temperature` then `tempsurvive.get_artificial_temperature`. This returns the temperature rounded down to one decimal place and the temperature converted to a Celsius or Fahrenheit string suffixed with the appropriate symbol.

Example:

```lua
local temp, tempStr = thermometer.getTemp({ x = 0, y = 0, z = 0})
print(temp) -- 12.8
-- if thermometer.celsius == false
print(tempStr) -- "55°F"
-- else
print(tempStr) -- "12.8°C"
```

## `thermometer.updateInvTemp(pos, inventory, listname)`

Use this function to loop through the inventory list items and get the temperature of the inventory. It updates any thermometers in it, and returns the temperature so you can store it in the metadata field of your choosing. For compatibility with this mod and any others that may want to use this functionality, I recommend storing it in the `inv_temp` field. It takes the position of the inventory (for getting the collective area and nearby nodes temperature) as `pos`, the InfRef as `inventory`, and the name of the list as `listname`.

Example:

```lua
local temp = thermometer.updateInvTemp(player:get_pos(), player:get_inventory(), 'main')
```

## tempsurvive

This mod uses `tempsurvive.spread_temperature`, `tempsurvive.get_bio_temperature`, `tempsurvive.get_artificial_temperature`, `tempsurvive.perlin`, and `tempsurvive.nodes` from the tempsurvive mod unless that mod is enabled. If its enabled, we set `tempsurvive.nodes` to equal `thermometer.temp_nodes`. Either way, `tempsurvive:thermometer` becomes an alias to `thermometer:spirit_thermometer`.
