tempsurvive = {
    perlin = {
        offset = 50,
        scale = 50,
        spread = { x = 1000, y = 1000, z = 1000 },
        seed = 5349,
        octaves = 3,
        persist = 0.5,
        lacunarity = 2,
        flags = "default"
    },
    nodes = thermometer.temp_nodes,
    player = {},
    speed = 0.01,
    step_timer = 0,
    step_time = 1,
}

tempsurvive.new = function(player)
    local name = player:get_player_name()
    tempsurvive.player[name] = {
        temp = 36,
        warming = 0,
        cooling = 0,
        heat_resistance = 40,
        coldness_resistance = -10,
        full_resistance = core.check_player_privs(name, { no_temperature = true }),
    }
end

core.register_on_joinplayer(function(player)
    tempsurvive.new(player)
end)

core.register_on_respawnplayer(function(player)
    local t = tempsurvive.player[player:get_player_name()]
    t.temp = 0
end)

core.register_on_leaveplayer(function(player)
    tempsurvive.player[player:get_player_name()] = nil
end)

tempsurvive.spread_temperature = function(target_pos, pos, add, rad)
    local td = vector.distance(target_pos, pos)
    if td < 1 then
        return add
    end
    local jobs = { pos }
    local checked = {}
    while #jobs > 0 and #jobs < 1000 do
        for i, p in pairs(jobs) do
            for x = -1, 1, 1 do
                for y = -1, 1, 1 do
                    for z = -1, 1, 1 do
                        local np = { x = p.x + x, y = p.y + y, z = p.z + z }
                        local ta = core.pos_to_string(np)
                        local d = vector.distance(pos, np)
                        local nod = core.registered_nodes[core.get_node(np).name]
                        if d <= rad and not checked[ta] and nod and not nod.walkable then
                            if vector.distance(target_pos, np) <= 1 then
                                return add / td
                            end
                            checked[ta] = true
                            table.insert(jobs, np)
                        end
                    end
                end
            end
            table.remove(jobs, i)
        end
    end
    return 0
end

tempsurvive.get_bio_temperature = function(pos)
    if pos.y < -50 then return 0 end
    local p = { x = math.floor(pos.x), y = 0, z = math.floor(pos.z) }
    local l = core.get_node_light(pos) or 0

    local temp = core.get_perlin(tempsurvive.perlin):get_2d({ x = p.x, y = p.z }) - 40

    if temp > 0 then
        return temp + ((l * 0.025) * temp)
    else
        return temp, temp + (l * 0.1)
    end
end

tempsurvive.get_artificial_temperature = function(pos, temp)
    local a = core.find_nodes_in_area({ x = pos.x - 3, y = pos.y - 3, z = pos.z - 3 },
        {
            x = pos.x + 3,
            y = pos.y + 3,
            z =
                pos.z + 3
        }, { "group:tempsurvive" })
    for i, no in pairs(a) do
        local name = core.get_node(no).name
        local add = 0
        local rad = core.get_item_group(name, "tempsurvive_rad")
        if core.get_item_group(name, "tempsurvive_temp_by_meta") > 0 then
            add = add + core.get_meta(no):get_int("temp")
        else
            add = core.get_item_group(name, "tempsurvive_add")
        end
        temp = temp + tempsurvive.spread_temperature(pos, no, add, rad)
    end
    return temp
end

core.register_on_mods_loaded(function()
    local groups_to_change = {}
    for i, v in pairs(tempsurvive.nodes) do
        if string.find(i, ":") == nil then
            groups_to_change[i] = v
        elseif core.registered_items[i] then
            local group = table.copy(core.registered_items[i].groups or {})
            group.tempsurvive = 1
            group.tempsurvive_add = v.add
            group.tempsurvive_rad = v.rad
            core.override_item(i, { groups = group })
        end
    end
    for i, v in pairs(core.registered_items) do
        for ii, vv in pairs(groups_to_change) do
            if v.groups[ii] then
                local group = table.copy(v.groups or {})
                group.tempsurvive = 1
                group.tempsurvive_add = vv.add
                group.tempsurvive_rad = vv.rad
                core.override_item(i, { groups = group })
                tempsurvive.nodes[i] = { add = vv.add, rad = vv.rad }
            end
        end
    end
    for ii, vv in pairs(groups_to_change) do
        tempsurvive.nodes[ii] = nil
    end
end)

core.register_globalstep(function(dtime)
    if tempsurvive.step_timer > tempsurvive.step_time then
        tempsurvive.step_timer = 0
    else
        tempsurvive.step_timer = tempsurvive.step_timer + dtime
        return
    end
    for _, player in ipairs(core.get_connected_players()) do
        local ptemp = tempsurvive.player[player:get_player_name()]
        if ptemp and not ptemp.full_resistance then
            local pos = player:get_pos()
            local temp = tempsurvive.get_bio_temperature(pos)
            local itn = player:get_wielded_item():get_name()

            if tempsurvive.nodes[itn] then
                temp = temp + tempsurvive.nodes[itn].add * 2
            end

            temp = tempsurvive.get_artificial_temperature(pos, temp)

            ptemp.temp = ptemp.temp - (math.floor(ptemp.temp - temp) * tempsurvive.speed)
        end
    end
end)
