-- 
-- Load support for MT game translation.
local S = minetest.get_translator("bucket")

-- NEW liquid definitions "bucket" liquid
minetest.register_node("bucket:bucket_water_source", {
                                                      description = S("Bucket Water Source"),
                                                      drawtype = "liquid",
                                                      waving = 3,
                                                      tiles = {
                                                               {
                                                                name = "default_water_source_animated.png",
                                                                backface_culling = false,
                                                                animation = {
                                                                             type = "vertical_frames",
                                                                             aspect_w = 16,
                                                                             aspect_h = 16,
                                                                             length = 2.0,
                                                                             },
                                                                },
                                                               {
                                                                name = "default_water_source_animated.png",
                                                                backface_culling = true,
                                                                animation = {
                                                                             type = "vertical_frames",
                                                                             aspect_w = 16,
                                                                             aspect_h = 16,
                                                                             length = 2.0,
                                                                             },
                                                                },
                                                               },
                                                      alpha = 191,
                                                      paramtype = "light",
                                                      walkable = false,
                                                      pointable = false,
                                                      diggable = false,
                                                      buildable_to = true,
                                                      is_ground_content = false,
                                                      drop = "",
                                                      drowning = 1,
                                                      liquidtype = "source",
                                                      liquid_renewable = false,
                                                      liquid_alternative_flowing = "bucket:bucket_water_flowing",
	liquid_alternative_source = "bucket:bucket_water_source",
	liquid_viscosity = 1,
	post_effect_color = {a = 103, r = 30, g = 60, b = 90},
	groups = {water = 3, liquid = 3, cools_lava = 1},
	sounds = default.node_sound_water_defaults(),
	})

minetest.register_node("bucket:bucket_water_flowing", {
	description = S("Flowing Bucket Water"),
	drawtype = "flowingliquid",
	tiles = {"default_river_water.png"},
	special_tiles = {
					{
						name = "default_water_flowing_animated.png",
						backface_culling = false,
						animation = {
									type = "vertical_frames",
									aspect_w = 16,
									aspect_h = 16,
									length = 0.5,
									},
						},
					{
						name = "default_water_flowing_animated.png",
						backface_culling = true,
						animation = {
									type = "vertical_frames",
									aspect_w = 16,
									aspect_h = 16,
									length = 0.5,
									},
						},
					},
	alpha = 160,
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "bucket:bucket_water_flowing",
	liquid_alternative_source = "bucket:bucket_water_source",
	liquid_viscosity = 1,
	liquid_renewable = false,
	liquid_range = 1,
	post_effect_color = {a = 103, r = 30, g = 76, b = 90},
	groups = {water = 3, liquid = 3, not_in_creative_inventory = 1,
				cools_lava = 1},
	sounds = default.node_sound_water_defaults(),
	})

minetest.register_node("bucket:bucket_lava_source", {
	description = S("Bucket Lava Source"),
	drawtype = "liquid",
	tiles = {
		{
			name = "default_lava_source_animated.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 3.0,
			},
		},
		{
			name = "default_lava_source_animated.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 3.0,
			},
		},
	},
	paramtype = "light",
	light_source = default.LIGHT_MAX - 1,
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_alternative_flowing = "bucket:bucket_lava_flowing",
	liquid_alternative_source = "bucket:bucket_lava_source",
	liquid_viscosity = 7,
	liquid_renewable = false,
	damage_per_second = 4 * 2,
	post_effect_color = {a = 191, r = 255, g = 64, b = 0},
	groups = {lava = 3, liquid = 2, igniter = 1},
})

minetest.register_node("bucket:bucket_lava_flowing", {
	description = S("Flowing Bucket Lava"),
	drawtype = "flowingliquid",
	tiles = {"default_lava.png"},
	special_tiles = {
		{
			name = "default_lava_flowing_animated.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 3.3,
			},
		},
		{
			name = "default_lava_flowing_animated.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 3.3,
			},
		},
	},
	paramtype = "light",
	paramtype2 = "flowingliquid",
	light_source = default.LIGHT_MAX - 1,
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "bucket:bucket_lava_flowing",
	liquid_alternative_source = "bucket:bucket_lava_source",
	liquid_viscosity = 7,
	liquid_renewable = false,
	damage_per_second = 4 * 2,
	post_effect_color = {a = 191, r = 255, g = 64, b = 0},
	groups = {lava = 3, liquid = 2, igniter = 1,
		not_in_creative_inventory = 1},
	liquid_range = 1,
})

-- Change Bucket Water to normal "default:water_source" on contact with it
minetest.register_abm({
                       nodenames = {"bucket:bucket_water_source"},
                       neighbors = {"default:water_source", "default:water_flowing"},
                       interval = 1.0, -- Run every 1 second
                       chance = 1, -- Select every 1 nod
                       action = function(pos, node, active_object_count, active_object_count_wider)
								local pos = {x = pos.x, y = pos.y, z = pos.z}
								minetest.set_node(pos, {name = "default:water_source"})
                       end
                       })

-- Change Bucket Water to normal "default:river_water_source" on contact with it
minetest.register_abm({
                       nodenames = {"bucket:bucket_water_source"},
                       neighbors = {"default:river_water_source", "default:river_water_flowing"},
                       interval = 1.0, -- Run every 1 second
                       chance = 1, -- Select every 1 nod
                       action = function(pos, node, active_object_count, active_object_count_wider)
								local pos = {x = pos.x, y = pos.y, z = pos.z}
								minetest.set_node(pos, {name = "default:river_water_source"})
                       end
                       })

-- Change Bucket Lava to normal on contact with lava or water
minetest.register_abm({
                       nodenames = {"bucket:bucket_lava_source"},
                       neighbors = {"default:lava_source", "default:lava_flowing", "default:water_source", "default:water_flowing", "default:river_water_source", "default:river_water_flowing", "bucket:bucket_water_source", "bucket:bucket_water_flowing"},
                       interval = 1.0, -- Run every 1 second
                       chance = 1, -- Select every 1 nod
                       action = function(pos, node, active_object_count, active_object_count_wider)
								local pos = {x = pos.x, y = pos.y, z = pos.z}
								minetest.set_node(pos, {name = "default:lava_source"})
                       end
                       })

minetest.register_abm({
                       nodenames = {"bucket:bucket_lava_flowing"},
                       neighbors = {"default:lava_source", "default:lava_flowing", "default:water_source", "default:water_flowing", "default:river_water_source", "default:river_water_flowing", "bucket:bucket_water_source"},
                       interval = 1.0, -- Run every 1 second
                       chance = 1, -- Select every 1 nod
                       action = function(pos, node, active_object_count, active_object_count_wider)
								local pos = {x = pos.x, y = pos.y, z = pos.z}
								minetest.set_node(pos, {name = "default:lava_flowing"})
                       end
                       })
 
