--
-- Load support for MT game translation.
local S = minetest.get_translator("bucket")

-- Default Liquid Namespace
Liquid_name = {}
Liquid_name.water = {}
Liquid_name.lava = {}

-- Default water and lava
Liquid_name.water.source = "default:water_source"
Liquid_name.water.flowing = "default:water_flowing"
Liquid_name.water.river_source = "default:river_water_source"
Liquid_name.water.river_flowing = "default:river_water_flowing"
Liquid_name.lava.source = "default:lava_source"
Liquid_name.lava.flowing = "default:lava_flowing"

--bucket waret and lava
Liquid_name.water.bucket_source = "bucket:bucket_water_source"
Liquid_name.water.bucket_flowing = "bucket:bucket_water_flowing"
Liquid_name.lava.bucket_source = "bucket:bucket_lava_source"
Liquid_name.lava.bucket_flowing = "bucket:bucket_lava_flowing"
	--Bucket river water not used (not needed yet)
	--Liquid_name.water.bucket_river_source = "bucket:bucket_river_water_source"
	--Liquid_name.water.bucket_river_flowing = "bucket:bucket_river_water_flowing"

-- Liquid flowing range definitions (Default)
local bucket_water_range = 1
local bucket_lava_range = 1
-- load settingtypes
bucket_water_range = minetest.settings:get("bucket_water_flowing_range") or bucket_water_range
bucket_lava_range = minetest.settings:get("bucket_lava_flowing_range") or bucket_lava_range

-- Registred nodes according to aliases
local water_source_def = minetest.deserialize(minetest.serialize(minetest.registered_nodes[Liquid_name.water.source]))
local water_flowing_def = minetest.deserialize(minetest.serialize(minetest.registered_nodes[Liquid_name.water.flowing]))
local lava_source_def = minetest.deserialize(minetest.serialize(minetest.registered_nodes[Liquid_name.lava.source]))
local lava_flowing_def = minetest.deserialize(minetest.serialize(minetest.registered_nodes[Liquid_name.lava.flowing]))

-- NEW liquid definitions "bucket" liquid
minetest.register_node(Liquid_name.water.bucket_source, water_source_def)
minetest.override_item(Liquid_name.water.bucket_source, {
	description = S("Bucket Water Source"),
	liquid_alternative_flowing = Liquid_name.water.bucket_flowing,
	liquid_alternative_source = Liquid_name.water.bucket_source,
	liquid_renewable = false,
})

minetest.register_node(Liquid_name.water.bucket_flowing, water_flowing_def)
minetest.override_item(Liquid_name.water.bucket_flowing, {
	description = S("Flowing Bucket Water"),
	liquid_alternative_flowing = Liquid_name.water.bucket_flowing,
	liquid_alternative_source = Liquid_name.water.bucket_source,
	liquid_range = bucket_water_range,
	liquid_renewable = false,
})

minetest.register_node(Liquid_name.lava.bucket_source, lava_source_def)
minetest.override_item(Liquid_name.lava.bucket_source, {
	description = S("Bucket Lava Source"),
	liquid_alternative_flowing = Liquid_name.lava.bucket_flowing,
	liquid_alternative_source = Liquid_name.lava.bucket_source,
	liquid_renewable = false,
})

minetest.register_node(Liquid_name.lava.bucket_flowing, lava_flowing_def)
minetest.override_item(Liquid_name.lava.bucket_flowing, {
	description = S("Bucket Lava Source"),
	liquid_alternative_flowing = Liquid_name.lava.bucket_flowing,
	liquid_alternative_source = Liquid_name.lava.bucket_source,
	liquid_range = bucket_lava_range,
	liquid_renewable = false,
})


-- Change Bucket Water to normal "water_source" on contact with it
minetest.register_abm({
	nodenames = {Liquid_name.water.bucket_source},
	neighbors = {Liquid_name.water.source,
				Liquid_name.water.flowing},
	interval = 1.0, -- Run every 1 second
	chance = 1, -- Select every 1 nod
	action = function(pos, node, active_object_count, active_object_count_wider)
			local pos = {x = pos.x, y = pos.y, z = pos.z}
			minetest.set_node(pos, {name = Liquid_name.water.source})
	end
})

--
minetest.register_abm({
	nodenames = {Liquid_name.water.bucket_flowing},
	neighbors = {Liquid_name.water.source,
				Liquid_name.water.flowing},
	interval = 1.0, -- Run every 1 second
	chance = 1, -- Select every 1 nod
	action = function(pos, node, active_object_count, active_object_count_wider)
			local pos = {x = pos.x, y = pos.y, z = pos.z}
			minetest.set_node(pos, {name = Liquid_name.water.flowing})
	end
})

-- Change Bucket Water to normal "river_water_source" on contact with it
minetest.register_abm({
	nodenames = {Liquid_name.water.bucket_source},
	neighbors = {Liquid_name.water.river_source,
				Liquid_name.water.river_flowing},
	interval = 1.0, -- Run every 1 second
	chance = 1, -- Select every 1 nod
	action = function(pos, node, active_object_count, active_object_count_wider)
			local pos = {x = pos.x, y = pos.y, z = pos.z}
			minetest.set_node(pos, {name = Liquid_name.water.river_source})
	end
})

-- Change Bucket Lava to normal on contact with lava or water
minetest.register_abm({
	nodenames = {Liquid_name.lava.bucket_source},
	neighbors = {Liquid_name.lava.source,
				Liquid_name.lava.flowing,
				Liquid_name.water.source,
				Liquid_name.water.flowing,
				Liquid_name.water.river_source,
				Liquid_name.water.river_flowing,
				Liquid_name.water.bucket_source,
				Liquid_name.water.bucket_flowing},
	interval = 1.0, -- Run every 1 second
	chance = 1, -- Select every 1 nod
	action = function(pos, node, active_object_count, active_object_count_wider)
			local pos = {x = pos.x, y = pos.y, z = pos.z}
			minetest.set_node(pos, {name = Liquid_name.lava.source})
	end
})

-- Bucket flowing Lava to normal on contact with lava or water
minetest.register_abm({
	nodenames = {Liquid_name.lava.bucket_flowing},
	neighbors = {Liquid_name.lava.source,
				Liquid_name.lava.flowing,
				Liquid_name.water.source,
				Liquid_name.water.flowing,
				Liquid_name.water.river_source,
				Liquid_name.water.river_flowing,
				Liquid_name.water.bucket_source},
	interval = 1.0, -- Run every 1 second
	chance = 1, -- Select every 1 nod
	action = function(pos, node, active_object_count, active_object_count_wider)
			local pos = {x = pos.x, y = pos.y, z = pos.z}
			minetest.set_node(pos, {name = Liquid_name.lava.flowing})
	end
})
