```
 ______        ____       ____     __  ______     .-------.        .-''-.     ____    ,---.    ,---. 
|    _ `''.  .'  __ `.    \   \   /  /|    _ `''. |  _ _   \     .'_ _   \  .'  __ `. |    \  /    | 
| _ | ) _  \/   '  \  \    \  _. /  ' | _ | ) _  \| ( ' )  |    / ( ` )   '/   '  \  \|  ,  \/  ,  | 
|( ''_'  ) ||___|  /  |     _( )_ .'  |( ''_'  ) ||(_ o _) /   . (_ o _)  ||___|  /  ||  |\_   /|  | 
| . (_) `. |   _.-`   | ___(_ o _)'   | . (_) `. || (_,_).' __ |  (_,_)___|   _.-`   ||  _( )_/ |  | 
|(_    ._) '.'   _    ||   |(_,_)'    |(_    ._) '|  |\ \  |  |'  \   .---..'   _    || (_ o _) |  | 
|  (_.\.' / |  _( )_  ||   `-'  /     |  (_.\.' / |  | \ `'   / \  `-'    /|  _( )_  ||  (_,_)  |  | 
|       .'  \ (_ o _) / \      /      |       .'  |  |  \    /   \       / \ (_ o _) /|  |      |  | 
'-----'`     '.(_,_).'   `-..-'       '-----'`    ''-'   `'-'     `'-..-'   '.(_,_).' '--'      '--' 
                 MTG (running on Luanti Engine) mods by daydream, Your Land server   
```

# Flight Speed ( flyspeed )

Minetest mod for changing the flight speed on-the-fly, using the `/flyspeed` command.

Original mod by ROllerozxa.

Optimized by Deedee Daydream 2025.

### Changelog / Improvements

- **Optimized Server Performance:** Rewrote the globalstep loop to use a state check. The original code sent a physics update to the server every single tick (approx. 20 times/second) for every player. The new code only sends updates when the player actually transitions between flying and walking, significantly reducing unnecessary network traffic and server load.

- **Fixed Downward Flight Physics:** Removed the velocity check (velocity.y >= 0) that caused the speed boost to disable whenever a player flew downwards. Flight speed is now consistent regardless of vertical direction (ascending, hovering, or diving).

- **Memory Cleanup:** Added a garbage collection check (register_on_leaveplayer) to clear player data from the temporary state table when they disconnect.

### Supported Languages
- English (en) - Default
- Spanish (es)
- Swedish (sv)
- German (de) *new*
- French (fr) *new*
- Russian (ru) *new*
- Portuguese (pt_BR) *new*

### Usage
Use `/flyspeed 2` or `/flyspeed 3`, etc. to double, triple or whatever speed you wish to fly.
Use `/flyspeed 1` to return to default speed. Enjoy!


```
             ⣤⡶⢶⣦⡀
⠀⠀⠀⣴⡿⠟⠷⠆⣠⠋⠀⠀⠀⢸⣿
⠀⠀⠀⣿⡄⠀⠀⠀⠈⠀⠀⠀⠀⣾⡿  ... dreaming of Minetest
⠀⠀⠀⠹⣿⣦⡀⠀⠀⠀⠀⢀⣾⣿
⠀⠀⠀⠀⠈⠻⣿⣷⣦⣀⣠⣾⡿
⠀⠀⠀⠀⠀⠀⠀⠉⠻⢿⡿⠟
⠀⠀⠀⠀⠀⠀⠀⠀⠀⡟⠀⠀⠀⢠⠏⡆⠀⠀⠀⠀⠀⢀⣀⣤⣤⣤⣀⡀
⠀⠀⠀⠀⠀⡟⢦⡀⠇⠀⠀⣀⠞⠀⠀⠘⡀⢀⡠⠚⣉⠤⠂⠀⠀⠀⠈⠙⢦⡀
⠀⠀⠀⠀⠀⡇⠀⠉⠒⠊⠁⠀⠀⠀⠀⠀⠘⢧⠔⣉⠤⠒⠒⠉⠉⠀⠀⠀⠀⠹⣆
⠀⠀⠀⠀⠀⢰⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⢻⠀⠀⣤⠶⠶⢶⡄⠀⠀⠀⠀⢹⡆
⠀⣀⠤⠒⠒⢺⠒⠀⠀⠀⠀⠀⠀⠀⠀⠤⠊⠀⢸⠀⡿⠀⡀⠀⣀⡟⠀⠀⠀⠀⢸⡇
⠈⠀⠀⣠⠴⠚⢯⡀⠐⠒⠚⠉⠀⢶⠂⠀⣀⠜⠀⢿⡀⠉⠚⠉⠀⠀⠀⠀⣠⠟
⠀⠠⠊⠀⠀⠀⠀⠙⠂⣴⠒⠒⣲⢔⠉⠉⣹⣞⣉⣈⠿⢦⣀⣀⣀⣠⡴⠟

```
