local data = {}
local S = core.get_translator('flyspeed2')
local storage = core.get_mod_storage()
local player_states = {} -- Stores current state to prevent lag

-- Load saved speeds
core.register_on_mods_loaded(function()
    data = core.parse_json(storage:get("data") or "{}")
end)

-- Save speed function
function update_speed(name, speed)
    data[name] = speed
    storage:set_string("data", core.write_json(data))
    player_states[name] = nil -- Reset state so new speed applies instantly
end

-- Chat command: /flyspeed <number>
core.register_chatcommand('flyspeed', {
    params = "<speed>",
    description = S("Change the flight speed."),
    privs = { fly = true },
    func = function(name, param)
        local speed = tonumber(param) or -1
        if speed >= 0 then
            core.chat_send_player(name, S("Set flight speed to @1", param))
            update_speed(name, speed)
        else
            core.chat_send_player(name, core.colorize("#ff0000", S("Invalid speed.")))
        end
    end,
})

-- The Main Loop (Optimized)
core.register_globalstep(function(dtime)
    for _, player in pairs(core.get_connected_players()) do
        local name = player:get_player_name()
        local target_speed = data[name]
        
        if target_speed then
            local pos = player:get_pos()
            -- Check if player is in mid-air (2 blocks of air)
            local node_below = core.get_node({x = pos.x, y = math.floor(pos.y) - 1, z = pos.z}).name
            local node_at = core.get_node({x = pos.x, y = math.floor(pos.y), z = pos.z}).name
            
            local is_flying = (node_below == "air" and node_at == "air")
            local current_state = player_states[name]
            
            -- only run this logic if the state has CHANGED
            if is_flying and current_state ~= "flying" then
                player:set_physics_override({ speed = target_speed })
                player_states[name] = "flying"
                
            elseif not is_flying and current_state ~= "ground" then
                player:set_physics_override({ speed = 1 })
                player_states[name] = "ground"
            end
        end
    end
end)

-- Cleanup when player leaves
core.register_on_leaveplayer(function(player)
    player_states[player:get_player_name()] = nil
end)