--[[

	Alien apples
	==============

	Copyright (C) 2020-2023 debiankaios

	GPL v3
	See LICENSE.txt for more information

	Alien

]]--

local S = minetest.get_translator()

local alien_bar_definition = {
	hud_elem_type = "statbar",
	position = {x = 0.5, y = 1},
	text = "alien_heart.png",
	text2 = "heart_gone.png",
	number = minetest.PLAYER_MAX_HP_DEFAULT,
	item = minetest.PLAYER_MAX_HP_DEFAULT,
	direction = 0,
	size = {x = 24, y = 24},
	offset = {x = (-10 * 12) - 25, y = -(48 + 24 + 16)},
}

minetest.register_node("alien_material:alien_apple", {
	description = S("Alien apple"),
	drawtype = "plantlike",
	tiles = {"alien_apple.png"},
	inventory_image = "alien_apple.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	is_ground_content = false,
	selection_box = {
		type = "fixed",
		fixed = {-3 / 16, -7 / 16, -3 / 16, 3 / 16, 4 / 16, 3 / 16}
	},
	groups = {fleshy = 3, dig_immediate = 3,},
	on_use = minetest.item_eat(20),
	sounds = default.node_sound_leaves_defaults(),
})
