--[[

	Alien Material
	==============

	Copyright (C) 2020-2023 debiankaios

	GPL v3
	See LICENSE.txt for more information

]]--

alien_material = {}

alien_material.version = "y21p1"
alien_material.status = "Pre"

-- dofile
dofile(minetest.get_modpath("alien_material") .. "/ores.lua")
dofile(minetest.get_modpath("alien_material") .. "/tools.lua")
dofile(minetest.get_modpath("alien_material") .. "/alien_apple.lua")
dofile(minetest.get_modpath("alien_material") .. "/biomes.lua")
-- test
dofile(minetest.get_modpath("alien_material") .. "/alienbench.lua")
dofile(minetest.get_modpath("alien_material") .. "/crafting.lua")
if minetest.get_modpath("3d_armor") then
	dofile(minetest.get_modpath("alien_material") .. "/armor.lua")
end
if minetest.get_modpath("mobs") then
	dofile(minetest.get_modpath("alien_material") .. "/alien.lua")
end

local S = minetest.get_translator("alien_material")

-- Food


minetest.register_privilege("alien", "Needed for special Things!")

minetest.register_craftitem("alien_material:alien_bread", {
		inventory_image = "alien_bread.png",
		description = S("Alien Bread"),
		on_use = minetest.item_eat(20),
})







-- Alien Diamond





minetest.register_node("alien_material:alien_diamond_block", {
		tiles = {
				"alien_diamond_block.png"
		},
		groups = {cracky = 1},
		drop = "alien_material:alien_diamond_block",
		description = S("Alien Diamond Block"),
		light_source = 15,
		sounds = default.node_sound_stone_defaults(),
})





minetest.register_node("alien_material:alien_diamond_ore", {
		tiles = {
				"default_stone.png^alien_diamond_ore.png"
		},
		groups = {cracky = 1},
		drop = "alien_material:alien_diamond",
		description = S("Alien Diamond Ore"),
		is_ground_content = true,
		legacy_mineral = true,
		light_source = 5,
		sounds = default.node_sound_stone_defaults(),
})






minetest.register_craftitem("alien_material:alien_diamond", {
		inventory_image = "alien_diamond.png",
		description = S("Alien Diamond"),
})


-- Alien Mese








minetest.register_node("alien_material:alien_mese_ore", {
	description = S("Alien Mese Ore"),
	tiles = {"default_stone.png^alien_mese_ore.png"},
	groups = {cracky = 1},
	is_ground_content = true,
	legacy_mineral = true,
	light_source = 5,
	drop = "alien_material:alien_mese",
	sounds = default.node_sound_stone_defaults(),
})






minetest.register_node("alien_material:alien_mese_block", {
		tiles = {
				"alien_mese_block.png"
		},
		groups = {cracky = 1},
		is_ground_content = true,
		legacy_mineral = true,
		drop = "alien_material:alien_mese_block",
		description = S("Alien Mese Block"),
		light_source = default.LIGHT_MAX/2,
		sounds = default.node_sound_stone_defaults(),
})





minetest.register_craftitem("alien_material:alien_mese", {
		inventory_image = "alien_mese.png",
		description = S("Alien Mese"),
})


minetest.register_craftitem("alien_material:alien_mese_fragment", {
		inventory_image = "alien_mese_fragment.png",
		description = S("Alien Mese fragments"),
})


--Alien Ore


minetest.register_craftitem("alien_material:alien_ingot", {
		inventory_image = "alien_ingot.png",
		description = S("Alien Ingot"),
})





minetest.register_node("alien_material:alien_block", {
		tiles = {
				"alien_block.png"
		},
		groups = {cracky = 1},
		drop = "alien_material:alien_block",
		description = S("Alien Block"),
		light_source = default.LIGHT_MAX,
		sounds = default.node_sound_metal_defaults(),
})





minetest.register_node("alien_material:alien_post_light", {
	description = S("Alien Post Light"),
	tiles = {"default_fence_wood.png", "default_fence_wood.png",
		"alien_post_light_side.png", "alien_post_light_side.png",
		"alien_post_light_side.png", "alien_post_light_side.png"},
	wield_image = "alien_post_light_side.png",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {
			{-2 / 16, -8 / 16, -2 / 16, 2 / 16, 8 / 16, 2 / 16},
		},
	},
	paramtype = "light",
	light_source = default.LIGHT_MAX,
	sunlight_propagates = true,
	is_ground_content = false,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 2},
	sounds = default.node_sound_wood_defaults(),
})
