local multiple_planets = minetest.settings:get_bool("pxs_multiple_planets")

minetest.register_alias("mapgen_stone", "pxs_default:proxima_stone")
minetest.register_alias("mapgen_water_source", "pxs_default:mars_stone")


if not multiple_planets then
minetest.register_biome({
  name = "Stoneland",
  node_top = "pxs_default:proxima_sand",
  depth_top = 1,
  node_filler = "pxs_default:proxima_stone",
  depth_filler = 3,
  node_stone = "pxs_default:proxima_stone",
  node_riverbed = "pxs_default:mars_stone",
  depth_riverbed = 2,
  node_dungeon = "pxs_default:mars_stone",
  node_dungeon_stair = "pxs_default:mars_stone",
  y_max = 31000,
  y_min = -31000,
  heat_point = 92,
  humidity_point = 16,
})

minetest.register_decoration({
    name = "pxs_default:alienflower",
		deco_type = "simple",
		place_on = {"pxs_default:proxima_sand"},
    sidelen = 16,
		fill_ratio = 0.0001,
		biomes = {"Stoneland"},
		y_max = 31000,
		y_min = 0,
		decoration = "pxs_default:alienflower",
    spawn_by = "air",
	})

minetest.register_decoration({
    name = "pxs_default:tiny_proxima_stone",
    deco_type = "simple",
    place_on = {"pxs_default:proxima_sand"},
    sidelen = 4,
    fill_ratio = 0.005,
    biomes = {"Stoneland"},
    y_max = 31000,
    y_min = 0,
    decoration = "pxs_default:tiny_proxima_stone",
})
elseif multiple_planets then
  minetest.register_biome({
    name = "Stoneland",
    node_top = "pxs_default:proxima_sand",
    depth_top = 1,
    node_filler = "pxs_default:proxima_stone",
    depth_filler = 3,
    node_stone = "pxs_default:proxima_stone",
    node_riverbed = "pxs_default:mars_stone",
    depth_riverbed = 2,
    node_dungeon = "pxs_default:mars_stone",
    node_dungeon_stair = "pxs_default:mars_stone",
    y_max = 93000,
    y_min = 31000,
    heat_point = 92,
    humidity_point = 16,
  })

  minetest.register_decoration({
      name = "pxs_default:alienflower",
  		deco_type = "simple",
  		place_on = {"pxs_default:proxima_sand"},
      sidelen = 16,
  		fill_ratio = 0.0001,
  		biomes = {"Stoneland"},
  		y_max = 93000,
  		y_min = 62000,
  		decoration = "pxs_default:alienflower",
      spawn_by = "air",
  	})

  minetest.register_decoration({
      name = "pxs_default:tiny_proxima_stone",
      deco_type = "simple",
      place_on = {"pxs_default:proxima_sand"},
      sidelen = 4,
      fill_ratio = 0.005,
      biomes = {"Stoneland"},
      y_max = 93000,
      y_min = 62000,
      decoration = "pxs_default:tiny_proxima_stone",
  })
end
