deoxidizer = {}
deoxidizer.recipes = {}

function deoxidizer.register_recipe(input, output_iron, output_trash)
  table.insert(deoxidizer.recipes, {input = input, oi = output_iron, ot = output_trash})
	--local mix_id = string.gsub(input_a, ":", "-")..string.gsub(input_b, ":", "-")
	--alienbench.mixes[mix_id] = {name = result.name, count = result.count}
end

local function deoxidizer_do(pos)
  local inv = minetest.get_meta(pos):get_inventory()
	local input = inv:get_stack("input", 1)
  local output_iron = inv:get_stack("output_iron", 1)
	local output_trash = inv:get_stack("output_trash", 1)
  for i, v in pairs(deoxidizer.recipes) do
    if inv:contains_item("input", v.input) then
      inv:add_item("output_iron", v.oi)
      inv:remove_item("input", v.input)
    end
  end
end

minetest.register_node("default:deoxidizer_1", {
  tiles = {"default_deoxidizer_1.png",},
  description = "Deoxidizer Level 1",
  groups = {picky = 4,},
  after_place_node = function(pos)
		local meta = minetest.get_meta(pos)
		local inv = meta:get_inventory()
		meta:set_string("infotext", "Deoxidizer")
		inv:set_size("fuel", 1)
		inv:set_size("input", 1)
		inv:set_size("output_iron", 1)
    inv:set_size("output_trash", 1)
		meta:set_string("formspec", [[
			size[8,8]
			box[-0.01,0;1.84,0.9;#555555]
			image[0,0;0.9,0.9;default_iron_lump.png]
			label[0.65,0.25;Deoxidizer]
      list[context;input;5,0;1,1;]
			list[context;fuel;2,1;1,1;]
      image[3,1;1,1;default_furnace_fire_bg.png]
			image[5,1;1,1;gui_furnace_arrow_bg.png^[transformR180]
			list[context;output_iron;5,2;1,1;]
			list[current_player;main;0,4;8,4;]
		]])
	end,
  on_metadata_inventory_put = function(pos)
		deoxidizer_do(pos)
	end,
	on_metadata_inventory_take = function(pos)
		deoxidizer_do(pos)
	end,
	on_metadata_inventory_move = function(pos)
		deoxidizer_do(pos)
	end,
})

deoxidizer.register_recipe("default:red_topas", "default:blue_topas")
