local S = minetest.get_translator("pxs_default")

dofile(minetest.get_modpath("pxs_default") .. "/deoxidizer.lua")
dofile(minetest.get_modpath("pxs_default") .. "/specialitems.lua")
dofile(minetest.get_modpath("pxs_default") .. "/alias.lua")

-- General Nodes

minetest.register_node("pxs_default:mars_stone", {
  description = S("Mars Stone"),
  tiles = {"default_mars_stone.png"},
  groups = {picky = 4, stone = 1, oxidized_stone = 1},
  drop = "pxs_default:mars_stone",
})

minetest.register_node("pxs_default:proxima_stone", {
  description = "Proxima Stone",
  tiles = {"default_proxima_stone.png"},
  groups = {picky = 5, stone = 1, oxidized_stone = 1},
  drop = "pxs_default:proxima_stone",
})

minetest.register_node("pxs_default:proxima_sand", {
  description = "Proxima Stone",
  tiles = {"default_proxima_sand.png"},
  groups = {spady = 1, sand = 1, falling_node = 1},
  drop = "pxs_default:proxima_sand",
})

minetest.register_node("pxs_default:tiny_proxima_stone", {
  description = "Tiny Proxima Stone",
  tiles = {"default_proxima_stone.png"},
  groups = {picky = 3, handy = 3, stone = 1, little_oxidized_stone = 1},
  drop = "pxs_default:tiny_proxima_stone",
  drawtype = "nodebox",
  node_box = {
	type = "fixed",
	fixed = {
		{-0.2500, -0.5000, -0.1563, 0.2500, -0.3750, 0.1563}
	 }
 },
 is_ground_content = true,
 legacy_mineral = true,
})

minetest.register_node("pxs_default:alienflower", {
  description = "Alienflower",
  walkable = false,
  tiles = {"default_alienflower_dark.png"},
  drawtype = "plantlike",
  inventory_image = "default_alienflower_dark.png",
  on_use = minetest.item_eat(2),
  groups = {snappy = 2},
  light_source = 9,
	selection_box = {
		type = "fixed",
		fixed = { -2/16, -7/16, -2/16, 2/16, 7/16, 2/16 },
	},
})

minetest.register_node("pxs_default:alienflower_original", {
  description = "Original Alienflower",
  walkable = false,
  tiles = {"default_alienflower_original.png"},
  drawtype = "plantlike",
  inventory_image = "default_alienflower_original.png",
  on_use = minetest.item_eat(2),
  groups = {snappy = 2},
  light_source = 9,
	selection_box = {
		type = "fixed",
		fixed = { -2/16, -7/16, -2/16, 2/16, 7/16, 2/16 },
	},
})

--General Items

minetest.register_craftitem("pxs_default:proxima_stone_stick", {
  description = "Stone Stick",
  inventory_image = "default_stone_stick.png",
  groups = {sticks = 1,},
})

--[[
Mineral and Ores
]]--

-- Minerals

minetest.register_craftitem("pxs_default:corundum", {
  description = "Corundum",
  inventory_image = "default_corundum.png",
  groups = {corundum = 1, mineral = 1, titanium = 3},
})

minetest.register_craftitem("pxs_default:corundum_blue", {
  description = "Blue Corundum",
  inventory_image = "default_corundum_blue.png",
  groups = {corundum = 1, mineral = 1},
})


-- Topas

minetest.register_craftitem("pxs_default:topas", {
  description = "Topas",
  inventory_image = "default_topas.png",
  groups = {topas = 1, mineral = 1},
})

minetest.register_craftitem("pxs_default:blue_topas", {
  description = "Blue Topas",
  inventory_image = "default_blue_topas.png",
  groups = {topas = 1, mineral = 1},
})

minetest.register_craftitem("pxs_default:red_topas", {
  description = "Red Topas",
  inventory_image = "default_red_topas.png",
  groups = {topas = 1, mineral = 1},
})

minetest.register_craftitem("pxs_default:yellow_topas", {
  description = "Yellow Topas",
  inventory_image = "default_yellow_topas.png",
  groups = {topas = 1, mineral = 1},
})

minetest.register_craftitem("pxs_default:orange_topas", {
  description = "Orange Topas",
  inventory_image = "default_orange_topas.png",
  groups = {topas = 1, mineral = 1},
})
minetest.register_craftitem("pxs_default:gray_topas", {
  description = "Gray Topas",
  inventory_image = "default_grey_topas.png",
  groups = {topas = 1, mineral = 1},
})
minetest.register_craftitem("pxs_default:purple_topas", {
  description = "Purple Topas",
  inventory_image = "default_purple_topas.png",
  groups = {topas = 1, mineral = 1},
})
minetest.register_craftitem("pxs_default:pink_topas", {
  description = "Pink Topas",
  inventory_image = "default_pink_topas.png",
  groups = {topas = 1, mineral = 1},
})
minetest.register_craftitem("pxs_default:brown_topas", {
  description = "Brown Topas",
  inventory_image = "default_brown_topas.png",
  groups = {topas = 1, mineral = 1},
})
minetest.register_craftitem("pxs_default:green_topas", {
  description = "Green Topas",
  inventory_image = "default_green_topas.png",
  groups = {topas = 1, mineral = 1},
})

-- Ores

minetest.register_craftitem("pxs_default:titanium_lump", {
  description = "Titanium lump",
  inventory_image = "default_titanium_lump.png",
  groups = {titanium = 1, mineral = 1},
})

minetest.register_craftitem("pxs_default:iron_lump", {
  description = "Iron lump",
  inventory_image = "default_iron_lump.png",
  groups = {titanium = 1, mineral = 1},
})

-- Craft

minetest.register_craft({
    type = "shaped",
    output = "pxs_default:proxima_stone_stick 8",
    recipe = {
        {"pxs_default:tiny_proxima_stone",},
        {"pxs_default:tiny_proxima_stone",},
    }
})

minetest.register_craft({
    type = "shaped",
    output = "pxs_default:proxima_stone_stick 9",
    recipe = {
        {"pxs_default:proxima_stone",},
    }
})

minetest.register_craft({
    type = "shaped",
    output = "pxs_default:proxima_stone",
    recipe = {
        {"pxs_default:proxima_stone_stick", "pxs_default:proxima_stone_stick", "pxs_default:proxima_stone_stick",},
        {"pxs_default:proxima_stone_stick", "pxs_default:proxima_stone_stick", "pxs_default:proxima_stone_stick",},
        {"pxs_default:proxima_stone_stick", "pxs_default:proxima_stone_stick", "pxs_default:proxima_stone_stick",},
    }
})
