-- Please Read all comments
-- Coments in: init.lua, tnt.lua, auto.lua
spleef = {}


arena_lib.register_minigame("spleef", {
  prefix = "[Sp] ",
  hub_spawn_point = { x = 27, y = 27.5, z = -33 },
  queue_waiting_time = 20,
  show_minimap = true,
  properties = {
    planting_locations = {{x=30, y=20, z=40}, {x=5, y=20, z=80}}, --you can override these parameters via your mod, of course
    is_resetting = false
  },
  disabled_damage_types = {"punch"},
  hotbar = {
    slots = 1,
    background_image = "spleef_gui_hotbar.png"
  },

})

if not minetest.get_modpath("lib_chatcmdbuilder") then
    dofile(minetest.get_modpath("spleef") .. "/chatcmdbuilder.lua")
end
dofile(minetest.get_modpath("spleef") .. "/walkover.lua")
dofile(minetest.get_modpath("spleef") .. "/tnt.lua")
dofile(minetest.get_modpath("spleef") .. "/auto.lua")
--dofile(minetest.get_modpath("spleef") .. "/saveandload/untils.lua")
--dofile(minetest.get_modpath("spleef") .. "/saveandload/reset.lua")
--dofile(minetest.get_modpath("spleef") .. "/saveandload/save.lua")
-- dofile(minetest.get_modpath("spleef") .. "/saveandload/reset.lua")
-- dofile(minetest.get_modpath("spleef") .. "/saveandload/reset.lua")
-- It doesn't work @Zughy

ChatCmdBuilder.new("spleef", function(cmd) -- In music is a music Cusade by KevinMacLeod which should using for one map

  -- create arena
  cmd:sub("create :arena", function(name, arena_name)
      arena_lib.create_arena(name, "spleef", arena_name)
  end)

  cmd:sub("create :arena :minplayers:int :maxplayers:int", function(name, arena_name, min_players, max_players)
      arena_lib.create_arena(name, "spleef", arena_name, min_players, max_players)
  end)

  -- remove arena
  cmd:sub("remove :arena", function(name, arena_name)
      arena_lib.remove_arena(name, "spleef", arena_name)
  end)

  -- list of the arenas
  cmd:sub("list", function(name)
      arena_lib.print_arenas(name, "spleef")
  end)

  -- enter editor mode
  cmd:sub("edit :arena", function(sender, arena)
      arena_lib.enter_editor(sender, "spleef", arena)
  end)

  -- enable and disable arenas
  cmd:sub("enable :arena", function(name, arena)
      arena_lib.enable_arena(name, "spleef", arena)
  end)

  cmd:sub("disable :arena", function(name, arena)
      arena_lib.disable_arena(name, "spleef", arena)
  end)

end, {
  description = [[

    (/help spleef)

    Use this to configure your arena:
    - create <arena name> [min players] [max players]
    - edit <arena name>
    - enable <arena name>

    Other commands:
    - remove <arena name>
    - disable <arena>
    ]],
})
