minetest.register_node("spleef:tnt",{
  tiles = {"tnt_top.png", "tnt_bottom.png", "tnt_side.png"},
  groups = {cracky = 3},
  description = "TNT+",

  on_punch = function(pos, node, puncher)
    if puncher:get_wielded_item():get_name() == "spleef:torch" then
      minetest.swap_node(pos, {name = "spleef:tnt_falling"})
      minetest.registered_nodes["spleef:tnt_falling"].on_construct(pos)
    end
  end,
  drops = "spleef:tnt",
  on_timer = function(pos)
    minetest.remove_node(pos)
    minetest.swap_node(pos, {name = "spleef:tnt_falling"})
    minetest.registered_nodes["spleef:tnt_falling"].on_construct(pos)
  end,
})

minetest.register_node("spleef:tnt_falling",{ -- fixed :)
  groups = {falling_node = 2, cracky = 3},
  tiles = {
    {
      name = "tnt_top_burning_animated.png",
      animation = {
        type = "vertical_frames",
        aspect_w = 16,
        aspect_h = 16,
        length = 1,
      }
    },
    "tnt_bottom.png", "tnt_side.png"
    },
  not_in_creative_inventory = true,
  drops = "spleef:tnt",
  on_construct = function(pos)
    minetest.get_node_timer(pos):start(4)
    minetest.check_for_falling(pos)
  end,
  on_timer = function(pos)
    minetest.remove_node(pos)
    minetest.swap_node(pos, {name = "air"})
  end,
})

minetest.register_craftitem("spleef:torch",{
  inventory_image = "default_torch_on_floor.png",
  description = "Torch for TNT"
})



minetest.register_abm({
	nodenames = {"spleef:tnt"},
	interval = 0.1,
	chance = 1,
	action = function(pos, node, active_object_count, active_object_count_wider)
		for _,object in ipairs(minetest.get_objects_inside_radius(pos, 1.2)) do
			if object:is_player() then
				minetest.get_node_timer(pos):start(2)
			end

		end
	end})
