local S = minetest.get_translator("tnttag")

tnttag = {}
tnttag.saved_huds = {}

local player_speed = minetest.settings:get("tnttag.player_speed") or 3
local player_jump = minetest.settings:get("tnttag.player_jump") or 1.2

minetest.register_on_joinplayer(function(player)
	print(player_speed)
end)

arena_lib.register_minigame("tnttag", {
	prefix = "[tnttag] ",
    icon = "tnttag.png",
	queue_waiting_time = 45,
	show_minimap = true,
	show_nametags = false,
	properties = {
		waves = 5, --How many waves needed. Warning at least one more player then waves are needed.
		wavetime = 30,
		pause_length = 5, -- future
	},
	temp_properties = {
		current_wave = 0,
		original_player_amount = 0,
		pause = false, -- future
	},
	player_properties = {
    	tagged = false,
		tnt_if_tagged,
	},
	in_game_physics = {
		speed = player_speed,
		jump = player_jump,
	},
	hotbar = {
      slots = 1,
      background_image = "tnttag_gui_hotbar.png"
    },
	disabled_damage_types = {"fall", "punch"},--drown? node_damage?
	celebration_time = 10,
    load_time = 5,
	time_mode = "decremental",
})

dofile(minetest.get_modpath("tnttag") .. "/api.lua")
dofile(minetest.get_modpath("tnttag") .. "/items.lua")
dofile(minetest.get_modpath("tnttag") .. "/entities.lua")



-- Thankyou to chmodsayshello ↑

dofile(minetest.get_modpath("tnttag") .. "/hud.lua")
dofile(minetest.get_modpath("tnttag") .. "/auto.lua")

minetest.register_privilege("tnttag_admin", S("Needed for tnttag"))

ChatCmdBuilder.new("tnttag", function(cmd)
  -- create arena
  cmd:sub("create :arena", function(name, arena_name)
      arena_lib.create_arena(name, "tnttag", arena_name)
  end)

  cmd:sub("create :arena :minplayers:int :maxplayers:int", function(name, arena_name, min_players, max_players)
      arena_lib.create_arena(name, "tnttag", arena_name, min_players, max_players)
  end)

  -- remove arena
  cmd:sub("remove :arena", function(name, arena_name)
      arena_lib.remove_arena(name, "tnttag", arena_name)
  end)

  -- list of the arenas
  cmd:sub("list", function(name)
      arena_lib.print_arenas(name, "tnttag")
  end)

  -- enter editor mode
  cmd:sub("edit :arena", function(sender, arena)
      arena_lib.enter_editor(sender, "tnttag", arena)
  end)

  -- enable and disable arenas
  cmd:sub("enable :arena", function(name, arena)
      arena_lib.enable_arena(name, "tnttag", arena)
  end)

  cmd:sub("disable :arena", function(name, arena)
      arena_lib.disable_arena(name, "tnttag", arena)
  end)

end, {
  description = [[

    (/help tnttag)

    Use this to configure your arena:
    - create <arena name> [min players] [max players]
    - edit <arena name>
    - enable <arena name>

    Other commands:
    - remove <arena name>
    - disable <arena>
    ]],
    privs = {
        tnttag_admin = true
    },
})
