local S = minetest.get_translator("tnttag")


arena_lib.on_load("tnttag", function(arena)
	arena.original_player_amount = arena.players_amount
	for p_name, stats in pairs(arena.players) do
		tnttag.generate_HUD(arena, p_name)
		--[[ arena.players[p_name].tnt_if_tagged = minetest.add_entity(minetest.get_player_by_name(p_name):get_pos(), "tnttag:tnt_if_tagged", nil)
		 arena.players[p_name].tnt_if_tagged:set_attach(minetest.get_player_by_name(p_name), "Head", {x=0, y=10, z=0})]]
	end
end)

arena_lib.on_start("tnttag", function(arena)
	arena.current_time = arena.wavetime*arena.waves
	tnttag.newwave(arena)
end)

arena_lib.on_quit("tnttag", function(arena, p_name, is_spectator, reason)
	if not is_spectator then
		tnttag.remove_tnthead(p_name)
		tnttag.remove_HUD(arena, p_name)
	end
end)

arena_lib.on_eliminate("tnttag", function(arena, p_name)
	tnttag.remove_tnthead(p_name)
	tnttag.remove_HUD(arena, p_name)
end)

arena_lib.on_celebration("tnttag", function(arena, winner)
	arena.current_time = 0
	for p_name,stats in pairs(arena.players) do
		tnttag.remove_tnthead(p_name)
	end
	tnttag.remove_HUD(arena, winner)
end)

arena_lib.on_time_tick("tnttag", function(arena)
	local taggersnum = 0
	for p_name,stats in pairs(arena.players) do
		if tnttag.gettagstatus(p_name, arena) then taggersnum = taggersnum + 1 end
	end
	if taggersnum == 0 then
		arena.current_time=arena.current_time-arena.current_time%arena.wavetime
	end
	tnttag.update_wave_timer_hud(arena)
	tnttag.update_player_count_hud(arena)
	if arena.current_time%arena.wavetime == 0 then
		for p_name in pairs(arena.players) do
	        if arena.players[p_name].tagged then
				tnttag.explode_player(p_name, arena)
			end
	    end
		tnttag.newwave(arena)
	end
end)

arena_lib.on_timeout("tnttag", function(arena)
	for p_name in pairs(arena.players) do
		if arena.players[p_name].tagged then
			tnttag.explode_player(p_name, arena)
		end
	end
end)



--arena_lib.is_player_in_queue(player, "tnttag")
--arena_lib.get_arena_by_player(player)
