--[[

	INDEX

	1--HAND
	2--NODES
	3--DECORATIONS
	4--ORES
	5--BIOMES

]]


-- HAND

core.register_item(':', {
    type = 'none',
    wield_image = 'hand.png',
    wield_scale = {x = 1, y = 1, z = 1},
    range = 20,
    tool_capabilities = {
        full_punch_interval = 0.9,
        max_drop_level = 0,
        damage_groups = {fleshy = 1},
    }
})

-- Unlimited node placement
core.register_on_placenode(function(pos, newnode, placer, oldnode, itemstack)
	if placer and placer:is_player() then
		return core.check_player_privs(placer:get_player_name(), { server = true })
	end
end)

-- Don't pick up if the item is already in the inventory
local old_handle_node_drops = minetest.handle_node_drops
function minetest.handle_node_drops(pos, drops, digger)
	if not digger or not digger:is_player() or
		not core.check_player_privs(digger:get_player_name(), { server = true }) then
		return old_handle_node_drops(pos, drops, digger)
	end
	local inv = digger:get_inventory()
	if inv then
		for _, item in ipairs(drops) do
			if not inv:contains_item("main", item, true) then
				inv:add_item("main", item)
			end
		end
	end
end


--NODES

core.register_node('blank:grass', {
    description = 'Grass',
    tiles = { 'grass.png' },
    groups = { dig_immediate = 3 },
    paramtype = "light",
})

core.register_node('blank:stone', {
    description = 'Stone',
    tiles = { 'stone.png' },
    groups = { dig_immediate = 3 },
    paramtype = "light",
})

core.register_node('blank:dirt', {
    description = 'Dirt',
    tiles = { 'dirt.png' },
    groups = { dig_immediate = 3 },
    paramtype = "light",
})

core.register_node('blank:ruby', {
    description = 'Ruby',
    tiles = { 'ruby.png' },
    groups = { dig_immediate = 3 },
    paramtype = "light",
})

core.register_node('blank:sapphire', {
    description = 'Sapphire',
    tiles = { 'sapphire.png' },
    groups = { dig_immediate = 3 },
    paramtype = "light",
})

core.register_node('blank:water', {
    description = 'Water',
    tiles = { 'water.png' },
    groups = { dig_immediate = 3 },
    paramtype = "light",
})

core.register_node('blank:river_water', {
    description = 'River Water',
    tiles = { 'river_water.png' },
    groups = { dig_immediate = 3 },
    paramtype = "light",
})

core.register_node('blank:wood', {
    description = 'Wood',
    tiles = { 'wood.png' },
    groups = { dig_immediate = 3 },
    paramtype = "light",
})

core.register_node('blank:leaves', {
    description = 'Leaves',
    tiles = { 'leaves.png' },
    groups = { dig_immediate = 3 },
    paramtype = "light",
})

core.register_node('blank:emerald', {
    description = 'Emerald',
    tiles = { 'emerald.png' },
    groups = { dig_immediate = 3 },
    paramtype = "light",
})

core.register_node('blank:mese', {
    description = 'Mese',
    tiles = { 'mese.png' },
    groups = { dig_immediate = 3 },
    light_source = 14,
    paramtype = "light",
})

-- THOSE ARE ESSENTIALS FOR LOADING A V7 MAP

core.register_alias('mapgen_stone', 'blank:stone')
core.register_alias('mapgen_water_source', 'blank:water')
core.register_alias('mapgen_river_water_source', 'blank:river_water')


-- DECORATIONS

core.register_node("blank:blank_flower", {
	description = "Blank Flower",
	drawtype = "plantlike",
	waving = 1,
	tiles = { "flower.png"},
	inventory_image = "flower.png",
	wield_image = "flower.png",
	sunlight_propagates = true,
	paramtype = "light",
	walkable = false,
	groups = { dig_immediate = 3, flower = 1 },
	light_source = 14,
})

core.register_node("blank:long_plant", {
	description = "Long Plant",
	drawtype = "plantlike",
	visual_scale = 2,
	waving = 1,
	tiles = { "long_plant.png"},
	inventory_image = "long_plant.png",
	wield_image = "long_plant.png",
	sunlight_propagates = true,
	paramtype = "light",
	walkable = false,
	groups = { dig_immediate = 3, flower = 1 },
})


core.register_decoration({
	name = "flower",
	deco_type = "simple",
	place_on = {"blank:grass"},
	sidelen = 16,
	fill_ratio = 0.005,
	y_max = 31000,
	y_min = 0,
	decoration = { "blank:blank_flower"},
	--wallmounted_rotate_vertical = true,
	--param2 = 1,
})

core.register_decoration({
	name = "long_plant",
	deco_type = "simple",
	place_on = {"blank:grass"},
	sidelen = 16,
	fill_ratio = 0.005,
	y_max = 31000,
	y_min = 0,
	decoration = { "blank:long_plant"},
	--wallmounted_rotate_vertical = true,
	--param2 = 1,
})

core.register_alias("blank_nodes:wood", "blank:wood")
core.register_alias( "blank_nodes:leaves", "blank:leaves")
core.register_decoration({
	name = "tree",
	deco_type = "schematic",
	place_on = {"blank:grass"},
	place_offset_y = 1,
	sidelen = 16,
	fill_ratio = 0.001,
	biomes = "normalland",
	y_max = 31000,
	y_min = 0,
	schematic = minetest.get_modpath("blank") .. "/schematics/tree.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

core.register_decoration({
	name = "stone house",
	deco_type = "schematic",
	place_on = {"blank:grass"},
	place_offset_y = 1,
	sidelen = 16,
	fill_ratio = 0.001,
	biomes = "normalland",
	y_max = 31000,
	y_min = 0,
	schematic = minetest.get_modpath("blank") .. "/schematics/stone_house.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

-- ORES

core.register_ore({
	ore_type = "scatter",
	ore = "blank:ruby",
	wherein = "blank:stone",
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 16,
	clust_size = 16,
	y_max = 31000,
	y_min = -127,
})

core.register_ore({
	ore_type = "scatter",
	ore = "blank:sapphire",
	wherein = "blank:stone",
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 16,
	clust_size = 16,
	y_max = 31000,
	y_min = -31000,
})

core.register_ore({
	ore_type = "scatter",
	ore = "blank:emerald",
	wherein = "blank:stone",
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 16,
	clust_size = 16,
	y_max = 31000,
	y_min = -31000,
})

core.register_ore({
	ore_type = "scatter",
	ore = "blank:mese",
	wherein = "blank:stone",
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 16,
	clust_size = 16,
	y_max = 31000,
	y_min = -31000,
})

-- BIOMES

core.register_biome({
	name = "grassland",
	node_top = "blank:grass",
	depth_top = 2,
	node_filler = "blank:dirt",
	depth_filler = 4,
	node_riverbed = "blank:river_water",
	node_stone = "blank:stone",
	node_water = "blank:water",
	depth_riverbed = 2,
	y_max = 31000,
	y_min = -100,
	heat_point = 10,
	humidity_point = 10,
})
