local allground = {}
local allbutterflies = {}

for i in ipairs(colors) do
	local name = colors[i][1]
	allground[i] = mymodname .. name
	allbutterflies[i] = mymodname .. name .. "_butterfly"
	register_decoration({
		name = name .. " tree",
		deco_type = "schematic",
		place_on = { mymodname .. name, mymodname .. name .. "_light", mymodname .. name .. "_dark" },
		sidelen = 16,
		fill_ratio = 0.001,
		biomes = name .. "land",
		y_max = 31000,
		y_min = 0,
		schematic = minetest.get_modpath(modname) .. "/schematics/" .. name .. "_tree.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})
	register_decoration({
		name = name .. " flower",
		deco_type = "simple",
		place_on = { mymodname .. name, mymodname .. name .. "_light", mymodname .. name .. "_dark" },
		sidelen = 16,
		fill_ratio = 0.005,
		biomes = name .. "land",
		y_max = 31000,
		y_min = 0,
		--decoration = "group:flower",
		decoration = mymodname .. name .. "_flower",
	})

	register_decoration({
		name = name .. " grass",
		deco_type = "simple",
		place_on = { mymodname .. name, mymodname .. name .. "_light", mymodname .. name .. "_dark" },
		sidelen = 16,
		fill_ratio = 0.005,
		biomes = name .. "land",
		y_max = 31000,
		y_min = 0,
		decoration = mymodname .. name .. "_grass",
	})
end

--[[

minetest.register_decoration({
	name = "weed_gold",
	deco_type = "simple",
	place_on = allground,
	sidelen = 16,
	fill_ratio = 0.005,
	y_max = 31000,
	y_min = 0,
	decoration = {mymodname .. "weed_gold", mymodname .. "plant", mymodname .. "plant2", mymodname .. "plant3", mymodname .. "hdplant"},
})
]]
minetest.register_decoration({
	name = "ground_flower",
	deco_type = "simple",
	place_on = allground,
	sidelen = 16,
	fill_ratio = 0.005,
	y_max = 31000,
	y_min = 0,
	decoration = { mymodname .. "ground_flower", mymodname .. "ground_flower_2" },
	--wallmounted_rotate_vertical = true,
	param2 = 1,
})

minetest.register_decoration({
	name = "ground_stars",
	deco_type = "simple",
	place_on = allground,
	sidelen = 16,
	fill_ratio = 0.005,
	y_max = 31000,
	y_min = 0,
	decoration = {
		mymodname .. "ground_cross_star",
		mymodname .. "ground_diamond_star",
		mymodname .. "ground_dark_star",
	},
	--wallmounted_rotate_vertical = true,
	param2 = 1,
})

-- S T A R S


minetest.register_decoration({
	name = mymodname .. "lowstar_low",
	deco_type = "simple",
	place_on = allground,
	place_offset_y = 10,
	sidelen = 80,
	fill_ratio = 0.003,

	y_max = 0,
	y_min = -31000,
	decoration = mymodname .. "lowstar",
})

minetest.register_decoration({
	name = mymodname .. "lowstar_high",
	deco_type = "simple",
	place_on = allground,
	place_offset_y = 14,
	sidelen = 80,
	fill_ratio = 0.003,

	y_max = 31000,
	y_min = -31000,
	decoration = mymodname .. "lowstar",
})


local S = minetest.get_translator("butterflies")

register_decoration({
	name = mymodname .. "butterfly",
	deco_type = "simple",
	place_on = allground,
	place_offset_y = 3,
	sidelen = 80,
	fill_ratio = 0.001,
	--biomes = {"grassland", "deciduous_forest"},
	y_max = 31000,
	y_min = 0,
	decoration = allbutterflies,
	--spawn_by = "group:flower",
	--num_spawn_by = 1
})

register_decoration({
	name = mymodname .. "grisa",
	deco_type = "simple",
	place_on = mymodname .. "gray",
	sidelen = 80,
	fill_ratio = 0.001,
	y_max = 31000,
	y_min = 0,
	decoration = mymodname .. "grisa",

})

register_decoration({
	name = mymodname .. "flamia",
	deco_type = "simple",
	place_on = mymodname .. "red",
	sidelen = 80,
	fill_ratio = 0.001,
	y_max = 31000,
	y_min = 0,
	decoration = mymodname .. "flamia",

})

register_decoration({
	name = mymodname .. "taroni",
	deco_type = "simple",
	place_on = mymodname .. "orange",
	sidelen = 80,
	fill_ratio = 0.001,
	y_max = 31000,
	y_min = 0,
	decoration = mymodname .. "taroni",

})

register_decoration({
	name = mymodname .. "blumia",
	deco_type = "simple",
	place_on = mymodname .. "blue",
	sidelen = 80,
	fill_ratio = 0.001,
	y_max = 31000,
	y_min = 0,
	decoration = mymodname .. "blumia",

})

register_decoration({
	name = mymodname .. "amarila",
	deco_type = "simple",
	place_on = mymodname .. "yellow",
	sidelen = 80,
	fill_ratio = 0.001,
	y_max = 31000,
	y_min = 0,
	decoration = mymodname .. "amarila",

})

register_decoration({
	name = mymodname .. "purpura",
	deco_type = "simple",
	place_on = mymodname .. "purple",
	sidelen = 80,
	fill_ratio = 0.001,
	y_max = 31000,
	y_min = 0,
	decoration = mymodname .. "purpura",

})

register_decoration({
	name = mymodname .. "rosa",
	deco_type = "simple",
	place_on = mymodname .. "pink",
	sidelen = 80,
	fill_ratio = 0.001,
	y_max = 31000,
	y_min = 0,
	decoration = mymodname .. "rosa",

})

register_decoration({
	name = mymodname .. "verda",
	deco_type = "simple",
	place_on = mymodname .. "green",
	sidelen = 80,
	fill_ratio = 0.001,
	y_max = 31000,
	y_min = 0,
	decoration = mymodname .. "verda",

})
