-- C O L O R E D  N O D E S

for i in ipairs(colors) do
	local name = colors[i][1]
	local colorizehsl = colors[i][2]
	local colorize = colors[i][3]
	local specificlightness = ":" .. globallightness

	if name == "white" then
		specificlightness = "60"
	elseif name == "black" then
		specificlightness = "-60"
	end
	
	colorize = colorize .. ":140^[contrast:30"
	-- H S L -  V E R S I O N

	register_node(mymodname .. name, {
		description = name,
		tiles = { "plain.png" .. colorize },
		groups = { dig_immediate = 3, ground = 1 },
		is_ground_content = true,
		sounds = colorlandia_sounds.dirt(),
	})

	if name ~= "white" and name ~= "black" then
		--minetest.after(3, minetest.chat_send_all, "hi " .. name )

		register_node(mymodname .. name .. "_light", {
			description = name .. " Light",
			tiles = { "plain.png" .. colorize .. ":40"},
			groups = { dig_immediate = 3, ground = 1 },
			is_ground_content = true,
			sounds = colorlandia_sounds.dirt(),
		})
		register_node(mymodname .. name .. "_dark", {
			description = name .. " Dark",
			tiles = { "plain.png" .. colorize .. ":-40"},
			groups = { dig_immediate = 3, ground = 1 },
			is_ground_content = true,
			sounds = colorlandia_sounds.dirt(),
		})
	end

	for i in ipairs(blocktypes) do
		local blocktype = blocktypes[i][1]
		local blocktype_lightsource = blocktypes[i][2]
		local blocktype_tile = blocktypes[i][3]
		local custom_sound

		if blocktype == "diamond" then
			custom_sound = colorlandia_sounds.glass()
		else custom_sound = colorlandia_sounds.dirt()
		end
		
		if blocktype_tile == nil then
			blocktype_tile = blocktype
		end

		register_node(mymodname .. name .. "_" .. blocktype, {
			description = name .. " " .. blocktype,
			tiles = { blocktype_tile .. colorize },
			groups = { dig_immediate = 3, block = 1 },
			is_ground_content = true,
			paramtype = "light",
			light_source = blocktype_lightsource,
			sounds = custom_sound
		})
	end

	-- E N D --> H S L  -  V E R S I O N

	register_alias("colorland:" .. name .. "_leaves", mymodname .. name .. "_leaves")
	register_node(mymodname .. name .. "_leaves", {
		description = name .. " Leaves",
		drawtype = "allfaces_optional",
		waving = 1,
		tiles = { "leaves.png" .. colorize  },
		--use_texture_alpha = "blend",
		--special_tiles = {'default_leaves_simple.png' .. colorize .. ':150'},
		sunlight_propagates = true,
		paramtype = "light",
		is_ground_content = false,
		groups = { dig_immediate = 3, leaves = 1 },
		sounds = colorlandia_sounds.grass(),
	})
	-- falling_node = 1

	register_node(mymodname .. name .. "_wood", {
		description = name .. " Wood",
		--drawtype = 'allfaces_optional',
		waving = 1,
		tiles = { "wood.png" .. colorize  },
		--special_tiles = {'default_leaves_simple.png' .. colorize .. ':150'},
		--sunlight_propagates = true,
		paramtype = "light",
		paramtype2 = "facedir",
		is_ground_content = false,
		groups = { dig_immediate = 3, leaves = 1 },
		sounds = colorlandia_sounds.wood(),
	})
	register_alias("colorland:" .. name .. "_tree", mymodname .. name .. "_tree")
	register_node(mymodname .. name .. "_tree", {
		description = name,
		tiles = {
			"tree_top.png" ..  colorize,
			"tree_top.png" ..  colorize,
			"tree.png" ..  colorize,
		},
		groups = { dig_immediate = 3 },
		--maybe good for STAIRS and SLABS?
		paramtype2 = "facedir",
		on_place = minetest.rotate_node,
		is_ground_content = true,
		sounds = colorlandia_sounds.wood(),
	})

	-- C O L U M N S
	register_node(mymodname .. name .. "_column_mid", {
		description = "Column mid " .. name,
		drawtype = "nodebox",
		tiles = { "plain.png^block.png" ..  colorize},
		paramtype = "light",
		paramtype2 = "facedir",
		is_ground_content = false,
		groups = { dig_immediate = 3, wall = 1 },
		--sounds = sounds,
		node_box = {
			type = "connected",
			--{-1/4, -1/2, -1/4, 1/4, 1/2, 1/4},			     
			fixed = { -0.25, -0.5, -0.25, 0.25, 0.5, 0.25 },
			connect_front = { -3 / 16, -1 / 2, -1 / 2, 3 / 16, 3 / 8, -1 / 4 },
			connect_left = { -1 / 2, -1 / 2, -3 / 16, -1 / 4, 3 / 8, 3 / 16 },
			connect_back = { -3 / 16, -1 / 2, 1 / 4, 3 / 16, 3 / 8, 1 / 2 },
			connect_right = { 1 / 4, -1 / 2, -3 / 16, 1 / 2, 3 / 8, 3 / 16 },
		},
		connects_to = { "group:wall", "group:block" },
		sounds = colorlandia_sounds.dirt(),
		--on_place = minetest.rotate_node,
	})

	register_node(mymodname .. name .. "_column_link", {
		description = "Column link " .. name,
		drawtype = "nodebox",
		tiles = { "plain.png^block.png" ..  colorize},
		paramtype = "light",
		paramtype2 = "facedir",
		is_ground_content = true,
		groups = { dig_immediate = 3 },
		--sounds = sounds,
		node_box = {
			type = "fixed",
			fixed = {
				{ -0.25, 0, -0.5, 0.25, 0.5, 0.5 },
			},
		},
		sounds = colorlandia_sounds.dirt(),
		--on_place = minetest.rotate_node,
	})

	register_node(mymodname .. name .. "_column_link_down", {
		description = "Column link down " .. name,
		drawtype = "nodebox",
		tiles = { "plain.png^block.png" ..  colorize },
		paramtype = "light",
		paramtype2 = "facedir",
		is_ground_content = true,
		groups = { dig_immediate = 3 },
		--sounds = sounds,
		node_box = {
			type = "fixed",
			fixed = {
				{ -0.25, 0, -0.5, 0.25, 0.5, 0.5 },
				{ -0.125, -0.5, -0.125, 0.125, 0, 0.125 },
				{ -0.1875, -0.5, -0.1875, 0.1875, -0.375, 0.1875 },
				{ -0.1875, -0.125, -0.1875, 0.1875, 0, 0.1875 },
			},
		},
		on_place = minetest.rotate_node,
		sounds = colorlandia_sounds.dirt(),
	})

	register_node(mymodname .. name .. "_column_bottom", {
		description = "Column bottom " .. name,
		drawtype = "nodebox",
		tiles = { "plain.png^block.png" ..  colorize },
		paramtype = "light",
		paramtype2 = "facedir",
		is_ground_content = true,
		groups = { dig_immediate = 3 },
		--sounds = sounds,
		node_box = {
			type = "fixed",
			fixed = {
				{ -0.25, -0.5, -0.25, 0.25, 0.5, 0.25 },
				{ -0.5, -0.5, -0.5, 0.5, -0.25, 0.5 },
				{ -0.375, -0.5, -0.375, 0.375, 0, 0.375 },
			},
		},
		on_place = minetest.rotate_node,
		sounds = colorlandia_sounds.dirt()
	})

	register_node(mymodname .. name .. "_column_crosslink", {
		description = "Column Crosslink " .. name,
		drawtype = "nodebox",
		tiles = { "plain.png^block.png" ..  colorize},
		paramtype = "light",
		paramtype2 = "facedir",
		is_ground_content = true,
		groups = { dig_immediate = 3 },
		--sounds = sounds,
		node_box = {
			type = "fixed",
			fixed = {
				{ -0.25, -0.5, -0.25, 0.25, 0.5, 0.25 },
				{ -0.5, 0, -0.25, 0.5, 0.5, 0.25 },
				{ -0.25, 0, -0.5, 0.25, 0.5, 0.5 },
				{ -0.4375, 0.0625, -0.4375, 0.4375, 0.4375, 0.4375 },
			},
		},
		on_place = minetest.rotate_node,
		sounds = colorlandia_sounds.dirt()
	})

	register_node(mymodname .. name .. "_butterfly", {
		description = name .. " Butterfly",
		drawtype = "plantlike",
		tiles = {
			{
				name = "butterfly_animated.png" .. colorize,
				animation = {
					type = "vertical_frames",
					aspect_w = 16,
					aspect_h = 16,
					length = 3,
				},
			},
		},
		inventory_image = "butterfly.png" .. colorize,
		wield_image = "butterfly.png" .. colorize,
		waving = 1,
		paramtype = "light",
		sunlight_propagates = true,
		walkable = false,
		groups = { dig_immediate = 3 },
		floodable = true,
		sounds = colorlandia_sounds.grass()
	})
	-- W A T E R   G L A S S - L I K E

	register_node(mymodname .. name .. "_glass", {
		drawtype = "glasslike_framed",
		description = name .. " Glass",
		tiles = { "glass_detail.png" .. colorize, "glass_bg.png" .. colorize},
		use_texture_alpha = "blend",
		paramtype = "light",
		sunlight_propagates = true,
		groups = { dig_immediate = 3 },
		is_ground_content = true,
		sounds = colorlandia_sounds.glass()
	})

	-- F L O W E R S
	register_node(mymodname .. name .. "_flower", {
		description = name .. " Flower",
		drawtype = "plantlike",
		waving = 1,
		tiles = { "flower.png" .. colorize },
		inventory_image = "flower.png" .. colorize ,
		wield_image = "flower.png" .. colorize ,
		sunlight_propagates = true,
		paramtype = "light",
		walkable = false,
		groups = { dig_immediate = 3, flower = 1 },
		sounds = colorlandia_sounds.grass()
		--sounds = default.node_sound_leaves_defaults(),
		--[[		selection_box = {
		type = 'fixed',
		fixed = box  
		}]]
	})

	-- L I A N A S
	register_node(mymodname .. name .. "_liana", {
		description = name .. " Liana",
		drawtype = "plantlike",
		tiles = { "liana.png" .. colorize },
		inventory_image = "liana.png" .. colorize ,
		--wield_image = "flower.png" .. colorize .. ":120",
		sunlight_propagates = true,
		paramtype = "light",
		walkable = false,
		climbable = true,
		groups = { dig_immediate = 3, flower = 1 },
		sounds = colorlandia_sounds.grass()
	})

	register_node(mymodname .. name .. "_grass", {
		waving = 1,
		description = name .. " Grass",
		tiles = { "grass.png" .. colorize  },
		inventory_image = "grass.png" .. colorize ,
		drawtype = "plantlike",
		walkable = false,
		use_texture_alpha = "blend",
		paramtype = "light",
		sunlight_propagates = true,
		groups = { dig_immediate = 3 },
		is_ground_content = true,
		sounds = colorlandia_sounds.grass()
	})

	-- M E S H E S

	--visual_scale = 0.0625,
	--wield_scale = {x = 0.07, y= 0.07, z=0.07},

	register_node(mymodname .. name .. "_bed", {
		drawtype = "mesh",
		description = name .. " bed",
		inventory_image = "bed_inventory.png" .. colorize,
		--paramtype = "light",
		paramtype2 = "facedir",
		--sunlight_propagates = true,
		-- Holds the texture for each 'material'
		tiles = {
			"bed.png" .. colorize,
		},
		groups = { dig_immediate = 3 },
		selection_box = {
			type = "fixed",
			fixed = { -0.5, -0.5, -0.5, 0.5, 0.5, 1.5 },
		},
		collision_box = {
			type = "fixed",
			fixed = { -0.5, -0.5, -0.5, 0.5, 0.5, 1.5 },
		},
		-- Path to the mesh
		mesh = "bed.obj",
		sounds = colorlandia_sounds.wood()
		--on_place = minetest.rotate_node,
	})

	register_node(mymodname .. name .. "_table", {
		drawtype = "mesh",
		description = name .. " Table mesa",
		paramtype = "light",
		paramtype2 = "facedir",
		--sunlight_propagates = true,
		-- Holds the texture for each 'material'
		tiles = {
			"table.png" .. colorize ,
		},
		groups = { dig_immediate = 3 },
		-- Path to the mesh
		mesh = "table.obj",
		on_place = minetest.rotate_node,
		sounds = colorlandia_sounds.wood()
	})

	register_node(mymodname .. name .. "_chair", {
		drawtype = "mesh",
		mesh = "chair.obj",
		description = name .. " Chair silla",
		tiles = {
			"chair.png" .. colorize,
		},
		paramtype = "light",
		paramtype2 = "facedir",
		--sunlight_propagates = true,
		groups = { dig_immediate = 3 },
		on_place = minetest.rotate_node,
		sounds = colorlandia_sounds.wood()
	})

	register_node(mymodname .. name .. "_sofa", {
		drawtype = "mesh",
		mesh = "sofa.obj",
		description = name .. " Sofa",
		tiles = {
			"sofa.png" .. colorize,
		},
		paramtype = "light",
		paramtype2 = "facedir",
		--ssunlight_propagates = true,
		-- Holds the texture for each 'material'
		groups = { dig_immediate = 3 },
		on_place = minetest.rotate_node,
		sounds = colorlandia_sounds.wood()
	})

	-- S T A I R S

	register_node(mymodname .. name .. "_stair", {
		description = name .. " Stair",
		drawtype = "nodebox",
		tiles = { "plain.png" .. colorize},
		--use_texture_alpha = def.use_texture_alpha,
		--sunlight_propagates = def.sunlight_propagates,
		--light_source = def.light_source,
		paramtype = "light",
		paramtype2 = "facedir",
		is_ground_content = false,
		groups = { dig_immediate = 3 },
		--sounds = sounds or def.sounds,
		node_box = {
			type = "fixed",
			fixed = {
				{ -0.5, -0.5, -0.5, 0.5, 0.0, 0.5 },
				{ -0.5, 0.0, 0.0, 0.5, 0.5, 0.5 },
			},
		},
		on_place = minetest.rotate_node,
		sounds = colorlandia_sounds.wood()
	})

	register_node(mymodname .. name .. "_slab", {
		description = name .. " Slab",
		drawtype = "nodebox",
		tiles = { "plain.png" .. colorize },
		--use_texture_alpha = def.use_texture_alpha,
		--sunlight_propagates = def.sunlight_propagates,
		--light_source = def.light_source,
		paramtype = "light",
		paramtype2 = "facedir",
		is_ground_content = false,
		groups = { dig_immediate = 3 },
		--sounds = sounds or def.sounds,
		node_box = {
			type = "fixed",
			fixed = { -0.5, -0.5, -0.5, 0.5, 0, 0.5 },
		},
		on_place = minetest.rotate_node,
		sounds = colorlandia_sounds.dirt()
	})

	register_node(mymodname .. name .. "_stair_outer", {
		description = name .. " Stair Outer",
		drawtype = "nodebox",
		tiles = { "plain.png" .. colorize },
		paramtype = "light",
		paramtype2 = "facedir",
		is_ground_content = false,
		groups = { dig_immediate = 3 },

		node_box = {
			type = "fixed",
			fixed = {
				{ -0.5, -0.5, -0.5, 0.5, 0.0, 0.5 },
				{ -0.5, 0.0, 0.0, 0.0, 0.5, 0.5 },
			},
		},
		on_place = minetest.rotate_node,
		sounds = colorlandia_sounds.dirt()
	})
	register_node(mymodname .. name .. "_stair_inner", {
		description = name .. " Stair Inner",
		drawtype = "nodebox",
		tiles = { "plain.png" .. colorize },
		paramtype = "light",
		paramtype2 = "facedir",
		is_ground_content = false,
		groups = { dig_immediate = 3 },

		node_box = {
			type = "fixed",
			fixed = {
				{ -0.5, -0.5, -0.5, 0.5, 0.0, 0.5 },
				{ -0.5, 0.0, 0.0, 0.5, 0.5, 0.5 },
				{ -0.5, 0.0, -0.5, 0.0, 0.5, 0.0 },
			},
		},
		on_place = minetest.rotate_node,
		sounds = colorlandia_sounds.dirt()
	})
end
--[[
register_node(mymodname .. "fence", {
	description = "fence",
	drawtype = "nodebox",
	tiles = { "fence.png" },
	paramtype = "light",
	paramtype2 = "facedir",
	is_ground_content = false,
	groups = { dig_immediate = 3, wall = 1 },
	node_box = {
		type = "connected",
		fixed = {
			{ -0.5, -0.5, -0.025, 0.5, 0.5, 0.025 },
		},
		connect_front = { -3 / 16, -1 / 2, -1 / 2, 3 / 16, 3 / 8, -1 / 4 },
		connect_left = { -1 / 2, -1 / 2, -3 / 16, -1 / 4, 3 / 8, 3 / 16 },
		connect_back = { -3 / 16, -1 / 2, 1 / 4, 3 / 16, 3 / 8, 1 / 2 },
		connect_right = { 1 / 4, -1 / 2, -3 / 16, 1 / 2, 3 / 8, 3 / 16 },
	},
	connects_to = { "group:wall", "group:block" },
	sounds = colorlandia_sounds.wood()
	--on_place = minetest.rotate_node,
})

register_node(mymodname .. "door", {
	description = "door",
	drawtype = "nodebox",
	tiles = { "door.png" },
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "facedir",
	is_ground_content = false,
	groups = { dig_immediate = 3 },
	node_box = {
		type = "fixed",
		fixed = {
			{ -0.5, -0.5, -0.025, 0.5, 1.5, 0.025 },
		},
	},
	sounds = colorlandia_sounds.wood()
	--on_place = minetest.rotate_node,
})
]]
--[[
		groups = { dig_immediate = 3 , },
		--sounds = sounds,
		node_box = {
			type = "connected",
			fixed = --{-1/4, -1/2, -1/4, 1/4, 1/2, 1/4},			     
{-0.25, -0.5, -0.25, 0.25, 0.5, 0.25},
			connect_front = {-3/16, -1/2, -1/2,  3/16, 3/8, -1/4},
			connect_left = {-1/2, -1/2, -3/16, -1/4, 3/8,  3/16},
			connect_back = {-3/16, -1/2,  1/4,  3/16, 3/8,  1/2},
			connect_right = { 1/4, -1/2, -3/16,  1/2, 3/8,  3/16},
		},
		connects_to = { "group:wall", "group:block" },
]]
-- F R A M E D   G L A S S
--[[
register_node(mymodname .. "glass_framed", {
	description = "Framed Glass",
	drawtype = "glasslike_framed_optional",
	tiles = { "glass.png", "glass_detail.png" },
	use_texture_alpha = "clip", -- only needed for stairs API
	paramtype = "light",
	sunlight_propagates = true,
	is_ground_content = false,
	groups = { dig_immediate = 3 },
	sounds = colorlandia_sounds.dirt()
})

register_node(mymodname .. "block_framed", {
	description = "Framed Block",
	drawtype = "glasslike_framed_optional",
	tiles = { "block_framed.png", "block_framed_detail.png" },
	use_texture_alpha = "clip", -- only needed for stairs API
	paramtype = "light",
	sunlight_propagates = true,
	is_ground_content = false,
	groups = { dig_immediate = 3 },
	sounds = colorlandia_sounds.dirt()
})
]]


register_node(mymodname .. "dirt_with_grass", {
	description = "Dirt with grass",
	tiles = { "dirt_with_grass.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	sounds = colorlandia_sounds.dirt()
})

-- O R E S

register_node(mymodname .. "amethyst", {
	description = "Purple Amethyst",
	tiles = { "amethyst.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 8,
	sounds = colorlandia_sounds.glass()
})

register_node(mymodname .. "bronze", {
	description = "Orange Bronze",
	tiles = { "bronze.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 8,
	sounds = colorlandia_sounds.glass()
})

register_node(mymodname .. "ruby", {
	description = "Red Ruby",
	tiles = { "ruby.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 8,
	sounds = colorlandia_sounds.glass()
})

register_node(mymodname .. "emerald", {
	description = "Green Emerald",
	tiles = { "emerald.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 8,
	sounds = colorlandia_sounds.glass()
})

register_node(mymodname .. "sapphire", {
	description = "Blue Sapphire",
	tiles = { "sapphire.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 8,
	sounds = colorlandia_sounds.glass()
})

register_node(mymodname .. "obsidian", {
	description = "Purple Dark Obsidian",
	tiles = { "obsidian.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 8,
	sounds = colorlandia_sounds.glass()
})

register_node(mymodname .. "mese", {
	description = "Yellow Mese",
	tiles = { "mese.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 8,
	sounds = colorlandia_sounds.glass()
})

register_node(mymodname .. "rock", {
	description = "Purple Dark rock",
	tiles = { "rock.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	--light_source = 8,
	sounds = colorlandia_sounds.glass()
})

register_node(mymodname .. "simple", {
	description = "Simple",
	tiles = { "simple.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 8,
	sounds = colorlandia_sounds.glass()
})

register_node(mymodname .. "crate", {
	description = "Crate",
	tiles = { "crate.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 8,
	sounds = colorlandia_sounds.glass()
})

register_node(mymodname .. "bluelila", {
	description = "Blue-lila",
	tiles = { "blue-lila.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 8,
	sounds = colorlandia_sounds.glass()
})


-------------------------------
-- V E G E T A T I O N
-------------------------------
--[[
register_node(mymodname .. 'plant', {
    description = 'Plant',
    tiles = { 'plant.png^[colorize:#A900FF:180' },
    inventory_image = 'plant.png^[colorize:#A900FF:180',
    drawtype = 'plantlike',
    walkable = false,
    use_texture_alpha = 'blend',
    paramtype = 'light',
    sunlight_propagates = true,
    groups = { dig_immediate = 3 },
    is_ground_content = true,
    		waving = 1,
})

register_node(mymodname .. 'plant2', {
    description = 'Plant 2',
    tiles = { 'plant2.png^[colorize:#389931:180' },
    inventory_image = 'plant2.png^[colorize:#389931:180',
    drawtype = 'plantlike',
    walkable = false,
    use_texture_alpha = 'blend',
    paramtype = 'light',
    sunlight_propagates = true,
    groups = { dig_immediate = 3 },
    is_ground_content = true,
    		waving = 1,
})

register_node(mymodname .. 'plant3', {
    description = 'Plant 3',
    tiles = { 'plant3.png^[colorize:#034485:180' },
    inventory_image = 'plant3.png^[colorize:#034485:180',
    drawtype = 'plantlike',
    walkable = false,
    use_texture_alpha = 'blend',
    paramtype = 'light',
    sunlight_propagates = true,
    groups = { dig_immediate = 3 },
    is_ground_content = true,
    		waving = 1,
})


]]

register_node(mymodname .. "ground_flower", {
	description = "Ground Flower",
	drawtype = "signlike",
	tiles = { "ground_flower.png" },
	inventory_image = "ground_flower.png",
	paramtype = "light",
	paramtype2 = "wallmounted",
	sunlight_propagates = true,
	walkable = false,
	is_ground_content = false,
	groups = { dig_immediate = 3 },
	waving = 1,
	sounds = colorlandia_sounds.grass()
	--sounds = default.node_sound_metal_defaults(),
})
register_node(mymodname .. "ground_flower_2", {
	description = "Ground Flower 2",
	drawtype = "signlike",
	tiles = { "ground_flower_2.png" },
	inventory_image = "ground_flower_2.png",
	paramtype = "light",
	paramtype2 = "wallmounted",
	sunlight_propagates = true,
	walkable = false,
	is_ground_content = false,
	groups = { dig_immediate = 3 },
	waving = 1,
	sounds = colorlandia_sounds.grass()
	--sounds = default.node_sound_metal_defaults(),
})
register_node(mymodname .. "ground_cross_star", {
	description = "Ground Cross Star",
	drawtype = "signlike",
	tiles = { "ground_cross_star.png" },
	inventory_image = "ground_cross_star.png^[opacity:225",
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "wallmounted",
	sunlight_propagates = true,
	walkable = false,
	light_source = 10,
	is_ground_content = false,
	groups = { dig_immediate = 3 },
	waving = 1,
	sounds = colorlandia_sounds.grass()
	--sounds = default.node_sound_metal_defaults(),
})

register_node(mymodname .. "ground_diamond_star", {
	description = "Ground Diamond Star",
	drawtype = "signlike",
	tiles = { "ground_diamond_star.png^[opacity:225" },
	inventory_image = "ground_diamond_star.png",
	use_texture_alpha = "blend",
	light_source = 10,
	paramtype = "light",
	paramtype2 = "wallmounted",
	sunlight_propagates = true,
	walkable = false,
	is_ground_content = false,
	groups = { dig_immediate = 3 },
	waving = 1,
	sounds = colorlandia_sounds.grass()

	--sounds = default.node_sound_metal_defaults(),
})

register_node(mymodname .. "ground_dark_star", {
	description = "Ground Dark Star",
	drawtype = "signlike",
	tiles = { "ground_dark_star.png^[opacity:225" },
	inventory_image = "ground_dark_star.png",
	use_texture_alpha = "blend",
	light_source = 10,
	paramtype = "light",
	paramtype2 = "wallmounted",
	sunlight_propagates = true,
	walkable = false,
	climbable = true,
	is_ground_content = false,
	groups = { dig_immediate = 3 },
	waving = 1,
	sounds = colorlandia_sounds.grass()

	--sounds = default.node_sound_metal_defaults(),
})

-- LOW  S T A R S

register_node(mymodname .. "lowstar", {
	description = "Lowstar",
	drawtype = "plantlike",
	tiles = {
		{
			name = "lowstar_animated.png",
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 3,
			},
		},
	},
	inventory_image = "lowstar.png",
	wield_image = "lowstar.png",
	waving = 1,
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	groups = { dig_immediate = 3 },
	light_source = 100,
	floodable = true,
	sounds = colorlandia_sounds.glass()

})

-- S P E C I A L  F L O W E R S

register_node(mymodname .. "grisa", {
	description = "Gray Grisa Flower",
	visual_scale = 1.5,
	drawtype = "plantlike",
	tiles = { "grisa.png" },
	inventory_image = "grisa.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	is_ground_content = false,
	groups = { dig_immediate = 3 },
	waving = 1,
	sounds = colorlandia_sounds.grass()
})

register_node(mymodname .. "flamia", {
	description = "Red Flamia Flower",
	visual_scale = 1.5,
	drawtype = "plantlike",
	tiles = { "flamia.png" },
	inventory_image = "flamia.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	is_ground_content = false,
	groups = { dig_immediate = 3 },
	waving = 1,
	sounds = colorlandia_sounds.grass()
})

register_node(mymodname .. "taroni", {
	description = "Orange Taroni Flower",
	visual_scale = 1.5,
	drawtype = "plantlike",
	tiles = { "taroni.png" },
	inventory_image = "taroni.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	is_ground_content = false,
	groups = { dig_immediate = 3 },
	waving = 1,
	sounds = colorlandia_sounds.grass()
})


register_node(mymodname .. "blumia", {
	description = "Blue Blumia Flower",
	visual_scale = 1.5,
	drawtype = "plantlike",
	tiles = { "blumia.png" },
	inventory_image = "blumia.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	is_ground_content = false,
	groups = { dig_immediate = 3 },
	waving = 1,
	sounds = colorlandia_sounds.grass()
})

register_node(mymodname .. "amarila", {
	description = "Yellow Amarila Flower",
	visual_scale = 1.5,
	drawtype = "plantlike",
	tiles = { "amarila.png" },
	inventory_image = "amarila.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	is_ground_content = false,
	groups = { dig_immediate = 3 },
	waving = 1,
	sounds = colorlandia_sounds.grass()
})

register_node(mymodname .. "purpura", {
	description = "Purple Purpura Flower",
	visual_scale = 1.5,
	drawtype = "plantlike",
	tiles = { "purpura.png" },
	inventory_image = "purpura.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	is_ground_content = false,
	groups = { dig_immediate = 3 },
	waving = 1,
	sounds = colorlandia_sounds.grass()
})

register_node(mymodname .. "rosa", {
	description = "Pink Rosa Flower",
	visual_scale = 1.5,
	drawtype = "plantlike",
	tiles = { "rosa.png" },
	inventory_image = "rosa.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	is_ground_content = false,
	groups = { dig_immediate = 3 },
	waving = 1,
	sounds = colorlandia_sounds.grass()
})

register_node(mymodname .. "verda", {
	description = "Green Verda Flower",
	visual_scale = 1.5,
	drawtype = "plantlike",
	tiles = { "verda.png" },
	inventory_image = "verda.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	is_ground_content = false,
	groups = { dig_immediate = 3 },
	waving = 1,
	sounds = colorlandia_sounds.grass()
})

register_node(mymodname .. "rose", {
	description = "Realistic Rose",
	--visual_scale = 1.5,
	drawtype = "plantlike",
	tiles = { "rose-realistic.png" },
	inventory_image = "rose-realistic.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	is_ground_content = false,
	groups = { dig_immediate = 3 },
	waving = 1,
	sounds = colorlandia_sounds.grass()
})

register_node(mymodname .. "plantarosa", {
	description = "Planta Rosa",
	visual_scale = 1.5,
	drawtype = "plantlike",
	tiles = { "planta-rosa.png" },
	inventory_image = "planta-rosa.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	is_ground_content = false,
	groups = { dig_immediate = 3 },
	waving = 1,
	sounds = colorlandia_sounds.grass()
})

--fire

register_node(mymodname .. "fire", {
	description = "Fire",
	drawtype = "firelike",
	tiles = {{
		name = "fire_basic_flame_animated.png",
		animation = {
			type = "vertical_frames",
			aspect_w = 16,
			aspect_h = 16,
			length = 1
		}}
	},
	inventory_image = "fire_basic_flame.png",
	paramtype = "light",
	light_source = 13,
	walkable = false,
	buildable_to = true,
	sunlight_propagates = true,
	floodable = true,
	damage_per_second = 4,
	groups = {igniter = 2, dig_immediate = 3, fire = 1},

})

-- Bookshelf
register_node(mymodname .. "bookshelf", {
	description = "Bookshelf",
		tiles = {
		"bookshelf-side.png", "bookshelf-side.png",
		"bookshelf-side.png", "bookshelf-side.png",
		"bookshelf-side.png", "bookshelf.png"
	},
	paramtype2 = "facedir",
	groups = { dig_immediate = 3 },
	sounds = colorlandia_sounds.wood()
})

-- furnace
register_node(mymodname .. "furnace", {
	description = "Furnace",
		tiles = {
		"horno-side.png", "horno-side.png",
		"horno-side.png", "horno-side.png",
		"horno-side.png", {
				name = "horno.png",
				animation = {
					type = "vertical_frames",
					aspect_w = 16,
					aspect_h = 16,
					length = 1,
				},
			},
	},
	paramtype2 = "facedir",
	light_source = 14,
	groups = { dig_immediate = 3 },
	sounds = colorlandia_sounds.wood()
})

-- TV
register_node(mymodname .. "tv", {
	description = "TV",
		tiles = {
		"tv-side.png", "tv-side.png",
		"tv-side.png", "tv-side.png",
		"tv-side.png", {
				name = "tv.png",
				animation = {
					type = "vertical_frames",
					aspect_w = 16,
					aspect_h = 16,
					length = 3,
				},
			},
	},
	paramtype2 = "facedir",
	light_source = 14,
	groups = { dig_immediate = 3 },
	sounds = colorlandia_sounds.wood()
})

register_node(mymodname .. "_laptop", {
		drawtype = "mesh",
		mesh = "laptop.obj",
		description = "Laptop",
		tiles = {"laptop-texture.png" },
		paramtype = "light",
		paramtype2 = "facedir",
		--ssunlight_propagates = true,
		-- Holds the texture for each 'material'
		groups = { dig_immediate = 3 },
		on_place = minetest.rotate_node,
		sounds = colorlandia_sounds.wood()
	})

register_node(mymodname .. "_joystick", {
		drawtype = "mesh",
		mesh = "joystick.obj",
		description = "Gaming Joystick",
		tiles = {"joystick-texture.png" },
		paramtype = "light",
		paramtype2 = "facedir",
		--ssunlight_propagates = true,
		-- Holds the texture for each 'material'
		groups = { dig_immediate = 3 },
		on_place = minetest.rotate_node,
		sounds = colorlandia_sounds.wood()
	})

    register_node(mymodname .. "_littleman", {
		drawtype = "mesh",
		mesh = "littleman.obj",
		description = "Littleman",
		tiles = {"littleman-texture.png" },
		paramtype = "light",
		paramtype2 = "facedir",
		--ssunlight_propagates = true,
		-- Holds the texture for each 'material'
		groups = { dig_immediate = 3 },
		on_place = minetest.rotate_node,
		sounds = colorlandia_sounds.wood()
	})

-- SIGNS

local function register_sign(material, desc, def)
	minetest.register_node(mymodname .. material, {
		description = desc,
		drawtype = "nodebox",
		tiles = {material .. ".png"},
		inventory_image = material .. ".png",
		wield_image = material .. ".png",
		paramtype = "light",
		paramtype2 = "wallmounted",
		sunlight_propagates = true,
		is_ground_content = false,
		walkable = false,
		use_texture_alpha = "opaque",
		node_box = {
			type = "wallmounted",
			wall_top    = {-0.4375, 0.4375, -0.3125, 0.4375, 0.5, 0.3125},
			wall_bottom = {-0.4375, -0.5, -0.3125, 0.4375, -0.4375, 0.3125},
			wall_side   = {-0.5, -0.3125, -0.4375, -0.4375, 0.3125, 0.4375},
		},
		groups = def.groups,
		legacy_wallmounted = true,
		sounds = def.sounds,

		on_construct = function(pos)
			local meta = minetest.get_meta(pos)
			meta:set_string("formspec", "field[text;;${text}]")
		end,
		on_receive_fields = function(pos, formname, fields, sender)
			local player_name = sender:get_player_name()
			if minetest.is_protected(pos, player_name) then
				minetest.record_protection_violation(pos, player_name)
				return
			end
			local text = fields.text
			if not text then
				return
			end
			if #text > 512 then
				minetest.chat_send_player(player_name, "Text too long")
				return
			end
			text = text:gsub("[%z-\8\11-\31\127]", "") -- strip naughty control characters (keeps \t and \n)
			--default.log_player_action(sender, ("wrote %q to the sign at"):format(text), pos)
			local meta = minetest.get_meta(pos)
			meta:set_string("text", text)

			if #text > 0 then
				meta:set_string("infotext", text)
			else
				meta:set_string("infotext", '')
			end
		end,
	})
end

register_sign("text_sign", "Text sign", {
	--sounds = default.node_sound_wood_defaults(),
	groups = {dig_immediate = 3}
})

colorlandia_nodes = {}
datatest_nodes = {}

function mysplit(inputstr, sep)
	if sep == nil then
		sep = "%s"
	end
	local mytable = {}
	for str in string.gmatch(inputstr, "([^" .. sep .. "]+)") do
		if string.match(str, "colorlandia") then
			mytable = colorlandia_nodes
		elseif string.match(str, "datatest") then
			mytable = datatest_nodes
		else
			table.insert(mytable, str)
		end
	end
end

local allnodes = minetest.registered_nodes

for i in pairs(allnodes) do
	mysplit(allnodes[i].name, ":")
end

for i in ipairs(colorlandia_nodes) do
	register_alias(myoldmodname .. colorlandia_nodes[i], mymodname .. colorlandia_nodes[i])
end
for i in ipairs(datatest_nodes) do
	register_alias("dt_nodes:" .. datatest_nodes[i], "datatest:" .. datatest_nodes[i])
end

register_alias(myoldmodname .. "firefly", mymodname .. "lowstar")

register_alias("mapgen_stone", mymodname .. "gray")
register_alias("mapgen_water_source", mymodname .. "blue_glass")
register_alias("mapgen_river_water_source", mymodname .. "blue_glass")
register_alias("mapgen_lava_source",  mymodname .. "yellow_glass")
