for i in ipairs(colors) do
	local name = colors[i][1]
	local hue = colors[i][2]
	local rgb = colors[i][3]
	local sound = colors[i][4]

	if sound == nil then
		sound = datatest_sounds.nota_do()
	end

	if name ~= "" then

		rgb = rgb .. ":180^[contrast:100:-80"
	
	end

	register_node(mymodname .. name .. "_data", {
		description = name .. "data block",
		--drawtype = "glasslike_framed",
		-- -- ,'data_detail.png' .. hue
		tiles = { "data_background.png^data.png" .. rgb },
		groups = { dig_immediate = 3 },
		is_ground_content = true,
		paramtype = "light",
		sounds = sound,
		light_source = 1,
		drop = mymodname .. name .. "_data_framed",
	})

	register_node(mymodname .. name .. "_data_framed", {
		description = name .. " data framed block",
		drawtype = "glasslike_framed",
		-- -- ,'data_detail.png' .. hue
		tiles = { "data_detail.png" .. rgb, "data_background.png" .. rgb },
		groups = { dig_immediate = 3 },
		is_ground_content = true,
		paramtype = "light",
		sounds = sound,
		light_source = 17,
	})

	register_node(mymodname .. name .. "_data_romboid", {
		description = name .. "data romboid",
		tiles = { "data_background.png^data_romboid.png" .. rgb },
		groups = { dig_immediate = 3 },
		is_ground_content = true,
		light_source = 20,
		paramtype = "light",
		sounds = sound,
	})

	register_node(mymodname .. name .. "_data_octagon", {
		description = name .. "data romboid",
		tiles = { "data_background.png^data_octagon.png" .. rgb },
		groups = { dig_immediate = 3 },
		is_ground_content = true,
		light_source = 20,
		paramtype = "light",
		sounds = sound,
	})

	register_node(mymodname .. name .. "_little_square_data", {
		description = name .. " little square data ",
		tiles = { "data_background.png^little_square.png" .. rgb },
		groups = { dig_immediate = 3 },
		is_ground_content = true,
		light_source = 20,
		paramtype = "light",
		sounds = sound,
	})

	register_node(mymodname .. name .. "_data_9", {
		description = name .. "data 9 block",
		tiles = { "data_background.png^data_9.png" .. rgb },
		groups = { dig_immediate = 3 },
		is_ground_content = true,
		light_source = 20,
		paramtype = "light",
		sounds = sound,
	})

	register_alias(myoldmodname .. name .. "_boxinbox", mymodname .. name .. "_lamp")
	register_node(mymodname .. name .. "_lamp", {
		description = name .. " Data Lamp",
		tiles = { "data_background.png^data_8.png" .. rgb },
		groups = { dig_immediate = 3 },
		is_ground_content = true,
		light_source = 12,
		paramtype = "light",
		sounds = sound,
	})

	register_node(mymodname .. name .. "_flower", {
		description = name .. " Data Flower",
		tiles = { "data_background.png^data_flower.png" .. rgb },
		groups = { dig_immediate = 3 },
		is_ground_content = true,
		light_source = 12,
		paramtype = "light",
		sounds = sound,
	})

	register_node(mymodname .. name .. "_data_square", {
		description = name .. " Square Data Block",
		tiles = { "data_background.png^data_square.png" .. rgb },
		groups = { dig_immediate = 3 },
		is_ground_content = true,
		paramtype = "light",
		sounds = sound,
		light_source = 10,
	})

	register_node(mymodname .. name .. "_data_3", {
		description = name .. " 3 Square Data Block",
		tiles = { "data_background.png^data_3.png" .. rgb },
		groups = { dig_immediate = 3 },
		is_ground_content = true,
		paramtype = "light",
		sounds = sound,
		light_source = 10,
	})

	register_node(mymodname .. name .. "_blinklight", {
		description = name .. " Blink light white",
		tiles = {
			{
				name = "blink_light.png" .. rgb,
				animation = {
					type = "vertical_frames",
					frames_w = 16,
					frames_h = 160,
					length = 1,
				},
			},
		},
		groups = { dig_immediate = 3 },
		is_ground_content = true,
		paramtype = "light",
		sounds = sound,
		light_source = 12,
	})

	register_node(mymodname .. name .. "_grass", {
		description = name .. " grass",
		drawtype = "plantlike",
		walkable = false,
		use_texture_alpha = "blend",
		inventory_image = "datatest_grass.png" .. rgb ,
		tiles = { "datatest_grass.png" .. rgb },
		groups = { dig_immediate = 3 },
		is_ground_content = true,
		paramtype = "light",
		sounds = sound,
		light_source = 10,
	})

end

register_node(mymodname .. "data_binary", {
	description = "Pure plain color block",
	tiles = {
		{
			name = "data_binary.png",
			animation = {
				type = "vertical_frames",
				frames_w = 16,
				frames_h = 64,
				frame_length = 2,
			},
		},
	},
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 8,
})

-- A N I M A T E D
register_node(mymodname .. "animated", {
	description = "Pure plain color block",
	tiles = {
		{
			name = "animated.png",
			animation = {
				type = "vertical_frames",
				frames_w = 16,
				frames_h = 64,
				frame_length = 2,
			},
		},
	},
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 8,
    sounds = datatest_sounds.random_note()
})
register_node(mymodname .. "faces_animated", {
	description = "Pure plain color block",
	tiles = {
		{
			name = "faces_animated.png",
			animation = {
				type = "vertical_frames",
				frames_w = 16,
				frames_h = 96,
				length = 6,
			},
		},
	},
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 8,
	sounds = datatest_sounds.random_note(),
})


register_node(mymodname .. "heart_animated", {
	description = "Heart animated",
	--wield_image = "heart.png",
	tiles = {
		{
			name = "heart_animated.png",
			animation = {
				type = "vertical_frames",
				frames_w = 16,
				frames_h = 64,
				length = 1,
			},
		},
	},
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 8,
	sounds = datatest_sounds.random_note(),
	on_use = minetest.item_eat(2)
})

-- INTERROGANT
register_node(mymodname .. "interrogant", {
	description = "Interrogant",
	tiles = {"interrogant.png"},
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 8,
	sounds = datatest_sounds.random_note(),
})


register_node(mymodname .. "virus", {
	description = "Virus",
	tiles = { "virus.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 12,
    sounds = datatest_sounds.random_note()
})

-- COIN

register_node(mymodname .. "coin", {
	description = "Coin",
	tiles = {
		{
			name = "coin_animated.png",
			animation = {
				type = "vertical_frames",
				frames_w = 16,
				frames_h = 64,
				length = 1,
			},
		},
	},
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 12,
    sounds = datatest_sounds.random_note()
})


register_node(mymodname .. "water", {
	description = "Water",
	tiles = { "water.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 12,
    sounds = datatest_sounds.random_note()
})

register_node(mymodname .. "man", {
	description = "Man",
	tiles = { "man.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 12,
    sounds = datatest_sounds.random_note()
})

register_node(mymodname .. "sword", {
	description = "Sword",
	tiles = { "sword.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 12,
    sounds = datatest_sounds.random_note()
})

register_node(mymodname .. "shield", {
	description = "Shield",
	tiles = { "shield.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 12,
    sounds = datatest_sounds.random_note()
})

register_node(mymodname .. "skull", {
	description = "Skull",
	tiles = { "skull.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 12,
    sounds = datatest_sounds.random_note()
})

register_node(mymodname .. "lock", {
	description = "Lock",
	tiles = { "lock.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 12,
    sounds = datatest_sounds.random_note()
})
register_node(mymodname .. "key", {
	description = "Key",
	tiles = { "key.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 12,
    sounds = datatest_sounds.random_note()
})

register_node(mymodname .. "sandclock", {
	description = "Sand Clock",
	--inventory_image = "sandclock.png",
	tiles = { 
		{	
		name = "sandclock-animation.png",
			animation = {
				type = "vertical_frames",
				frames_w = 16,
				frames_h = 96,
				length = 3,
			},
		},
		},
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 12,
    sounds = datatest_sounds.random_note()
})

register_node(mymodname .. "poop", {
	description = "Poop",
	tiles = { "poop.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 12,
    sounds = datatest_sounds.random_note()
})

register_node(mymodname .. "pick", {
	description = "Pick",
	tiles = { "pick.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 12,
    sounds = datatest_sounds.random_note()
})

register_node(mymodname .. "shovel", {
	description = "Shovel",
	tiles = { "shovel.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 12,
    sounds = datatest_sounds.random_note()
})

register_node(mymodname .. "hand", {
	description = "Hand",
	tiles = { "myhand.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 12,
    sounds = datatest_sounds.random_note()
})

register_node(mymodname .. "sapling", {
	description = "Sapling",
	tiles = { "sapling.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 12,
    sounds = datatest_sounds.random_note()
})

register_node(mymodname .. "hammer", {
	description = "Hammer",
	tiles = { "hammer.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 12,
    sounds = datatest_sounds.random_note()
})

register_node(mymodname .. "golem", {
	description = "Golem",
	tiles = { "golem.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 12,
    sounds = datatest_sounds.random_note()
})

register_node(mymodname .. "woman", {
	description = "Woman",
	tiles = { "woman.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 12,
    sounds = datatest_sounds.random_note()
})

register_node(mymodname .. "totem", {
	description = "Totem",
	tiles = { "totem.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 12,
    sounds = datatest_sounds.random_note()
})

register_node(mymodname .. "xd", {
	description = "xD",
	tiles = { "xd.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 12,
    sounds = datatest_sounds.random_note()
})




register_node(mymodname .. "animation_mandala", {
	description = "Mandala animated",
	--wield_image = "heart.png",
	tiles = {
		{
			name = "animation_mandala.png",
			animation = {
				type = "vertical_frames",
				frames_w = 16,
				frames_h = 192,
				length = 3,
			},
		},
	},
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 8,
	sounds = datatest_sounds.random_note(),
})

-- R A I N B O W

register_node(mymodname .. "rainbow", {
	description = "Rainbow",
	tiles = { "rainbow.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 12,
    sounds = datatest_sounds.random_note()
})

register_node(mymodname .. "rainbow_radial", {
	description = "Rainbow Radial",
	tiles = { "rainbow_radial.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 12,
    sounds = datatest_sounds.random_note()
})

register_alias(myoldmodname .. "blinklight", mymodname .. "_blinklight")
register_alias(myoldmodname .. "data_3", mymodname .. "_data_3")
register_alias(myoldmodname .. "boxinbox", mymodname .. "_lamp")
register_alias(myoldmodname .. "data", mymodname .. "_data")
register_alias(myoldmodname .. "data_square", mymodname .. "_data_square")
