-- Simple formspec wrapper that does variable substitution.
function formspec_wrapper(formspec, variables)
	local retval = formspec

	for k,v in pairs(variables) do
		retval = retval:gsub("${"..k.."}", v)
	end

	return retval
end


local storage = minetest.get_mod_storage()


--[[
<big>Rules</big>
1. <b>Have fun.</b>
2. <b>Let others have fun.</b>
<b>- - - * - - -</b>
]]

local hypertext_text = [[
<center><big>Welcome to <b>Colorlandia</b>!</big>
<b>- - - * - - -</b>
A creative exploration game to build
 whatever you imagine with voxels.
The world is currently 2048x2048 in size. 
<b>- - - * - - -</b>
Game made by <b>dibesfer</b>.com
Check our discord: https://discord.gg/tUHBS9eERn
</center>
]]
--Feel ready to start? <action name=security><style color=#00ff00>Click here to answer the verification question.</style></action>
--		box[0.25,0.25;13.5,9.5;#00000088]
local formspec_text = formspec_wrapper([[
		formspec_version[4]
		size[14,6]

		hypertext[0.5,0.5;13,9;welcometext;${hypertext_text}]
		button_exit[4.5,5;5,0.9;btn_confirm;OK]
	]], { hypertext_text = hypertext_text })

local security_formspec_text = [[
	formspec_version[4]
	size[13,7.65]
	hypertext[0.5,0.75;13,10;lol;In order to be granted interact privileges you need to answer this question.

	What is the square root of
	<mono>floor(pi) * 48 + ( sin(pi) * e )</mono> ?]
	field[0.5,4.5;12,0.8;answer;;]
	${error}
	button[7.5,6;5,0.9;btn_confirm;Submit]
]]

function show_welcome_formspec(playername)
	minetest.show_formspec(playername, 'vmc_server:welcomescreen', formspec_text)
end

function show_security_formspec(playername, wrong)
	local errormsg = ''
	if wrong then
		errormsg = "label[1,6.5;"..red("Wrong answer!").."]"
	end

	minetest.show_formspec(playername, 'vmc_server:welcomescreen',
		formspec_wrapper(security_formspec_text, {
			error = errormsg
		}))
end

function verified(name)
	return storage:get_int(name) == 1
end

function success(name)
	-- check for interact ban
	if not no_touch_griefer.check_ban(minetest.get_player_ip(name)) then
		storage:set_int(name, 1)

		local pri = minetest.get_player_privs(name)
		pri["interact"] = true
		minetest.set_player_privs(name, pri)

		minetest.chat_send_player(name, green("You answered the question correctly and have now been granted interact privileges!"))
		minetest.close_formspec(name, "vmc_server:welcomescreen")
	else
		-- ew
		minetest.chat_send_player(name, red("LOL you're still interact banned."))
	end
end

minetest.register_on_joinplayer(function(player, last_login)
	local name = player:get_player_name()
		show_welcome_formspec(name)
end)

minetest.register_on_player_receive_fields(function(player, formname, fields)
	if formname ~= 'vmc_server:welcomescreen' then return end
	local name = player:get_player_name()

			minetest.chat_send_player(name, yellow("Use /welcome to reshow the welcome page."))

end)

minetest.register_chatcommand("welcome", {
	params = "",
	description = "Reshow the welcome screen.",
	func = function(name, param)
		show_welcome_formspec(name)
	end
})

minetest.register_chatcommand("pruneplayers", {
	params = "",
	description = "Prune players who haven't been verified.",
	privs = { server = true },
	func = function(name, param)
		local handler = minetest.get_auth_handler()

		for pname in handler.iterate() do
			if not verified(pname) then
				minetest.chat_send_player(name, yellow(pname.." has not been verified, pruning them..."))
				minetest.remove_player(pname)
				minetest.remove_player_auth(pname)
			end
		end
	end
})