for i in ipairs(colors) do
	local name = colors[i][1]
	local hue = colors[i][2]
	local rgb = colors[i][3]
	local sound = colors[i][4]

	if sound == nil then
		sound = datatest_sounds.nota_do()
	end

	register_node(mymodname .. name .. "_data", {
		description = name .. "data block",
		--drawtype = "glasslike_framed",
		-- -- ,'data_detail.png' .. hue
		tiles = { "data_background.png^data.png" .. hue },
		groups = { dig_immediate = 3 },
		is_ground_content = true,
		paramtype = "light",
		sounds = sound,
		light_source = 1,
		drop = mymodname .. name .. "_data_framed",
	})

	register_node(mymodname .. name .. "_data_framed", {
		description = name .. " data framed block",
		drawtype = "glasslike_framed",
		-- -- ,'data_detail.png' .. hue
		tiles = { "data_detail.png" .. hue, "data_background.png" .. hue },
		groups = { dig_immediate = 3 },
		is_ground_content = true,
		paramtype = "light",
		sounds = sound,
		light_source = 17,
	})

	register_node(mymodname .. name .. "_data_romboid", {
		description = name .. "data romboid",
		tiles = { "data_background.png^data_romboid.png" .. hue },
		groups = { dig_immediate = 3 },
		is_ground_content = true,
		light_source = 20,
		paramtype = "light",
		sounds = sound,
	})

	register_node(mymodname .. name .. "_data_octagon", {
		description = name .. "data romboid",
		tiles = { "data_background.png^data_octagon.png" .. hue },
		groups = { dig_immediate = 3 },
		is_ground_content = true,
		light_source = 20,
		paramtype = "light",
		sounds = sound,
	})

	register_node(mymodname .. name .. "_little_square_data", {
		description = name .. " little square data ",
		tiles = { "data_background.png^little_square.png" .. hue },
		groups = { dig_immediate = 3 },
		is_ground_content = true,
		light_source = 20,
		paramtype = "light",
		sounds = sound,
	})

	register_node(mymodname .. name .. "_data_9", {
		description = name .. "data 9 block",
		tiles = { "data_background.png^data_9.png" .. hue },
		groups = { dig_immediate = 3 },
		is_ground_content = true,
		light_source = 20,
		paramtype = "light",
		sounds = sound,
	})

	register_alias(myoldmodname .. name .. "_boxinbox", mymodname .. name .. "_lamp")
	register_node(mymodname .. name .. "_lamp", {
		description = name .. " Data Lamp",
		tiles = { "data_background.png^data_8.png" .. hue },
		groups = { dig_immediate = 3 },
		is_ground_content = true,
		light_source = 12,
		paramtype = "light",
		sounds = sound,
	})

	register_node(mymodname .. name .. "_flower", {
		description = name .. " Data Flower",
		tiles = { "data_background.png^data_flower.png" .. hue },
		groups = { dig_immediate = 3 },
		is_ground_content = true,
		light_source = 12,
		paramtype = "light",
		sounds = sound,
	})

	register_node(mymodname .. name .. "_data_square", {
		description = name .. " Square Data Block",
		tiles = { "data_background.png^data_square.png" .. hue },
		groups = { dig_immediate = 3 },
		is_ground_content = true,
		paramtype = "light",
		sounds = sound,
		light_source = 10,
	})

	register_node(mymodname .. name .. "_data_3", {
		description = name .. " 3 Square Data Block",
		tiles = { "data_background.png^data_3.png" .. hue },
		groups = { dig_immediate = 3 },
		is_ground_content = true,
		paramtype = "light",
		sounds = sound,
		light_source = 10,
	})

	register_node(mymodname .. name .. "_blinklight", {
		description = name .. " Blink light white",
		tiles = {
			{
				name = "blink_light.png" .. hue,
				animation = {
					type = "vertical_frames",
					frames_w = 16,
					frames_h = 160,
					length = 1,
				},
			},
		},
		groups = { dig_immediate = 3 },
		is_ground_content = true,
		paramtype = "light",
		sounds = sound,
		light_source = 12,
	})
end

register_node(mymodname .. "data_binary", {
	description = "Pure plain color block",
	tiles = {
		{
			name = "data_binary.png",
			animation = {
				type = "vertical_frames",
				frames_w = 16,
				frames_h = 64,
				frame_length = 2,
			},
		},
	},
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 8,
})

-- A N I M A T E D
register_node(mymodname .. "animated", {
	description = "Pure plain color block",
	tiles = {
		{
			name = "animated.png",
			animation = {
				type = "vertical_frames",
				frames_w = 16,
				frames_h = 64,
				frame_length = 2,
			},
		},
	},
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 8,
    sounds = datatest_sounds.random_note()
})
register_node(mymodname .. "faces_animated", {
	description = "Pure plain color block",
	tiles = {
		{
			name = "faces_animated.png",
			animation = {
				type = "vertical_frames",
				frames_w = 16,
				frames_h = 96,
				length = 6,
			},
		},
	},
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 8,
	sounds = datatest_sounds.random_note(),
})

-- R A I N B O W

register_node(mymodname .. "rainbow", {
	description = "Rainbow",
	tiles = { "rainbow.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 12,
    sounds = datatest_sounds.random_note()
})

register_node(mymodname .. "rainbow_radial", {
	description = "Rainbow Radial",
	tiles = { "rainbow_radial.png" },
	groups = { dig_immediate = 3 },
	is_ground_content = true,
	light_source = 12,
    sounds = datatest_sounds.random_note()
})

register_alias(myoldmodname .. "blinklight", mymodname .. "_blinklight")
register_alias(myoldmodname .. "data_3", mymodname .. "_data_3")
register_alias(myoldmodname .. "boxinbox", mymodname .. "_lamp")
register_alias(myoldmodname .. "data", mymodname .. "_data")
register_alias(myoldmodname .. "data_square", mymodname .. "_data_square")
