jds_hollow_logs_modname = core.get_current_modname()

local modpath = core.get_modpath(jds_hollow_logs_modname)

local hollow_template = {
    _mcl_hardness = 2,
    collision_box = {
        fixed = {
			{-0.5, -0.5, -0.5, 0.5, 0.5, -0.375},
			{-0.5, -0.5, -0.5, -0.375, 0.5, 0.5},
			{0.375, -0.5, -0.5, 0.5, 0.5, 0.5},
			{-0.5, -0.5, 0.375, 0.5, 0.5, 0.5}
		},
		type = "fixed"
	},
    drawtype = "mesh",
    mesh = "jds_hollow_logs_log.obj",
    on_place = mcl_util.rotate_axis,
    on_rotate = screwdriver.rotate_3way,
    paramtype = "light",
    paramtype2 = "facedir",
    sounds = mcl_sounds.node_sound_wood_defaults(),
    sunlight_propagates = true
}

local function get_description(name, is_stripped)
    local translations = dofile(modpath.."/descriptions.lua")
    local log_description = translations.log[name]
    local stripped_log_description = translations.stripped_log[name]

    return is_stripped and stripped_log_description or log_description
end

for name, definitions in pairs(mcl_trees.woods) do
    if name ~= "bamboo" then
        -- s = stripped, h = hollow, l = log, p = planks
        -- "hs" only means hanging_sign when used in this specific sequence
        local l_itemstring = "mcl_trees:tree_"..name
        local l_definitions = core.registered_nodes[l_itemstring]
        local l_tiles = l_definitions.tiles
        local hl_itemstring = "mcl_trees:hollow_"..name
        local sl_itemstring = "mcl_trees:stripped_"..name
        local sl_definitions = core.registered_nodes[sl_itemstring]
        local sl_old_groups = sl_definitions.groups
        local sl_tiles = sl_definitions.tiles
        local shl_itemstring = "mcl_trees:hollow_stripped_"..name
        local p_itemstring = "mcl_trees:wood_"..name.." 2"
        local hs_itemstring = "mcl_signs:hanging_sign_"..name
        local s_group = "group:stripped_"..name

        local groups = {
            axey = 1, building_block = 1, fire_encouragement = 5, fire_flammability = 20,
            flammable = 3, handy = 1, material_wood = 1, tree = 1
        }

        if definitions.tree and definitions.tree.groups then
            groups = definitions.tree.groups
        end

        core.register_node(":"..hl_itemstring, table.merge(hollow_template, {
            _mcl_burntime = l_definitions._mcl_burntime,
            _mcl_cooking_output = l_definitions._mcl_cooking_output,
            _mcl_crafting_output = {single = {output = p_itemstring}},
            _mcl_stripped_variant = shl_itemstring,
            _on_axe_place = mcl_trees.strip_tree,
            description = get_description(name, false),
            groups = groups,
            tiles = {l_tiles[1], l_tiles[3], sl_tiles[3]}
        }))

        core.register_node(":"..shl_itemstring, table.merge(hollow_template, {
            _mcl_burntime = sl_definitions._mcl_burntime,
            _mcl_cooking_output = sl_definitions._mcl_cooking_output,
            _mcl_crafting_output = {single = {output = p_itemstring}},
            description = get_description(name, true),
            groups = table.merge(groups, {["stripped_"..name] = 1}),
            tiles = {sl_tiles[1], sl_tiles[3], sl_tiles[3]}
        }))

        core.register_craft({
            output = hl_itemstring.." 4",
            recipe = {
                {"", l_itemstring, ""},
                {l_itemstring, "", l_itemstring},
                {"", l_itemstring, ""}
            },
            replacements = {
                {l_itemstring, p_itemstring},
                {l_itemstring, p_itemstring},
                {l_itemstring, p_itemstring},
                {l_itemstring, p_itemstring}
            }
        })

        core.register_craft({
            output = shl_itemstring.." 4",
            recipe = {
                {"", sl_itemstring, ""},
                {sl_itemstring, "", sl_itemstring},
                {"", sl_itemstring, ""}
            },
            replacements = {
                {sl_itemstring, p_itemstring},
                {sl_itemstring, p_itemstring},
                {sl_itemstring, p_itemstring},
                {sl_itemstring, p_itemstring}
            }
        })

        core.clear_craft({output = hs_itemstring})

        core.override_item(sl_itemstring, {
            groups = table.merge(sl_old_groups, {["stripped_"..name] = 1})
        })

        core.register_craft ({
			output = hs_itemstring.." 6",
			recipe = {
				{"mcl_lanterns:chain","","mcl_lanterns:chain"},
				{s_group, s_group, s_group},
				{s_group, s_group, s_group}
			}
		})
        -- Compatibility with old mcl_hollow_logs
        core.register_alias("mcl_trees:stripped_hollow_"..name, shl_itemstring)
    end
end

dofile(modpath.."/compat.lua")
