---@class tablelib
---@field merge function

local S = core.get_translator("mcl_hollow_logs")

local tpl_hollow = {
    _mcl_blast_resistance = 2,
    _mcl_hardness = 2,
    climbable = true,
    collision_box = {
        fixed = {
			{-0.5, -0.5, -0.5, 0.5, 0.5, -0.375},
			{-0.5, -0.5, -0.5, -0.375, 0.5, 0.5},
			{0.375, -0.5, -0.5, 0.5, 0.5, 0.5},
			{-0.5, -0.5, 0.375, 0.5, 0.5, 0.5}
		},
		type = "fixed"
	},
    drawtype = "mesh",
    mesh = "mcl_hollow_logs_log.obj",
    paramtype = "light",
    paramtype2 = "facedir",
    on_place = mcl_util.rotate_axis,
    on_rotate = screwdriver.rotate_3way,
    sounds = mcl_sounds.node_sound_wood_defaults(),
    sunlight_propagates = true
}

for wood, defs in pairs(mcl_trees.woods) do
    if wood ~= "bamboo" then
        local groups = {
            axey = 1, fire_encouragement = 5, fire_flammability = 20, flammable = 3, handy = 1,
            material_wood = 1
        }
        local material = "mcl_trees:tree_" .. wood
        local strip_material = "mcl_trees:stripped_" .. wood
        local base_defs = core.registered_nodes[material]
        local strip_defs = core.registered_nodes[strip_material]

        if defs.tree and defs.tree.groups then
            groups = defs.tree.groups
        end

        core.register_node(":mcl_trees:hollow_" .. wood, table.merge(tpl_hollow, {
            _mcl_burntime = base_defs._mcl_burntime,
            _mcl_cooking_output = base_defs._mcl_cooking_output,
            _mcl_stripped_variant = "mcl_trees:stripped_hollow_"..wood,
            _on_axe_place = mcl_trees.strip_tree,
            description = S("@1 Hollow Log", defs.readable_name),
            groups = groups,
            tiles = {base_defs.tiles[3], base_defs.tiles[1], strip_defs.tiles[3]}
        }))

        base_defs = strip_defs

        core.register_node(":mcl_trees:stripped_hollow_"..wood, table.merge(tpl_hollow, {
            _mcl_burntime = base_defs._mcl_burntime,
            _mcl_cooking_output = base_defs._mcl_cooking_output,
            description = S("Stripped @1 Hollow Log", defs.readable_name),
            groups = groups,
            tiles = {strip_defs.tiles[3], strip_defs.tiles[1], strip_defs.tiles[3]}
        }))

        core.register_craft({
            output = "mcl_trees:hollow_" .. wood .. " 4",
            recipe = {
                {"", material, ""},
                {material, "", material},
                {"", material, ""}
            }
        })

        core.register_craft({
            output = "mcl_trees:stripped_hollow_" .. wood .. " 4",
            recipe = {
                {"", strip_material, ""},
                {strip_material, "", strip_material},
                {"", strip_material, ""}
            }
        })
    end
end

dofile(core.get_modpath("mcl_hollow_logs") .. "/compat.lua")
