# Cid

This mod provides a system for adding and playing music in Minetest, primarily designed for playing single-instrument MIDI files.

This mod does not provide any music. You will need to install a music pack or some other dependent mod.

# API
# cid.tunes

Table containing tunes, indexed by the tune id. Values are tables in the following format:

```lua
{
	title = "Title of piece"
	license = "License and/or other info",
	backend = "midi", -- "midi" | "table"
	_data = dofile("mytable.lua"), -- Used only by the table backend
	_midi = "Binary string", -- Data read from a MIDI file
}
```

# cid.instruments

Table indexed by instrument name, and an instrument definition as the value.

```lua
{
	name = "cid_piano", -- Name of the sound file
	gain = 1 / 2, -- Adjusts volume
	pitch = 60, -- MIDI pitch value, describes the sound sample's pitch
}
```

Some instruments are provided by default. cid.instruments.piano is the default instrument.

## cid.backends
Contains a bunch of the backend stuff, can be used directly to set up music players.

Currently undocumented, see init.lua and backends/midi.lua.
