--[[
Copyright 2023 ekl

This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this
file, You can obtain one at https://mozilla.org/MPL/2.0/.
]]
---@class TablePlayer: MidiPlayer
---@field data table
local Player = {
	index = 1,
	wait = 0,
}
Player.__index = Player
setmetatable(Player, cid.backends.midi._player)

function Player:step(dtime, player)
	self.wait = self.wait + dtime
	while true do
		local note = self.data[self.index]
		if not note then
			return true
		end

		if self.wait < note.t then
			return
		end
		self.wait = self.wait - note.t

		if note.p then
			if note.v then
				self:playNote(note.p, note.v, note.c or 0, player)
			else
				self:stopNote(note.p, note.c or 0)
			end
		end

		self.index = self.index + 1
	end
end

return {
	play = function(data, instrument)
		return setmetatable({ data = data._data, instrument = instrument }, Player)
	end,
}
