"""
Copyright 2023 ekl

This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this
file, You can obtain one at https://mozilla.org/MPL/2.0/.
"""
# Implements conversion from MIDI to table format

import mido
import sys

midi = mido.MidiFile(sys.argv[1])

data = []
for evt in midi:
    if evt.type == "note_on":
        note = dict(
            c=evt.channel,
            p=evt.note,
        )
        if evt.velocity != 0:
            note["v"] = evt.velocity
        note["t"] = evt.time
        data.append(note)
    elif evt.type == "note_off":
        data.append(
            dict(
                c=evt.channel,
                p=evt.note,
                t=evt.time,
            )
        )
    else:
        if evt.time:
            data.append(dict(t=evt.time))
print("return {")
for event in data:
    print(f"{{{','.join(f'{k}={v}' for k,v in event.items())}}},")
print("}")
