--[[
Copyright 2023 ekl

This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this
file, You can obtain one at https://mozilla.org/MPL/2.0/.
]]
---@diagnostic disable: undefined-global
local modName = minetest.get_current_modname()
local modDir = minetest.get_modpath(modName)
local function loadMusic(filename)
	local file = io.open(filename, "rb")
	assert(file, ("Missing music file: %s"):format(filename))
	local data = file:read("*a")
	file:close()
	return data
end

--Information about available tracks is parsed directly from LICENSE.txt
local file = io.open(modDir .. "/LICENSE.txt", "r")
assert(file)
local license = file:read("*a")
file:close()
for id, licenseInfo in license:gmatch("#%+begin_tune (.-)\n(.-\n)#%+end_tune") do
	local fileName = licenseInfo:match("File:%s*(.-)\n")
	local subDir = fileName:match("(.-)/")
	if subDir == "tables" then
		cid.tunes[id] = {
			title = licenseInfo:match("Title:%s*(.-)\n"),
			license = licenseInfo,
			backend = "table",
			_data = dofile(("%s/%s"):format(modDir, fileName)),
		}
	else
		cid.tunes[id] = {
			title = licenseInfo:match("Title:%s*(.-)\n"),
			license = licenseInfo,
			_midi = loadMusic(("%s/%s"):format(modDir, fileName)),
		}
	end
end
