--[[
Copyright 2023 ekl

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
--]] --
local supportedTools = {
  ["default:sword_mese"] = "end_him_rightly:sword_mese",
  ["default:sword_steel"] = "end_him_rightly:sword_steel",
  ["default:sword_stone"] = "end_him_rightly:sword_stone",
  ["default:sword_diamond"] = "end_him_rightly:sword_diamond",
  ["default:sword_bronze"] = "end_him_rightly:sword_bronze"
}

minetest.register_tool("end_him_rightly:pommel", {
  visual = "wielditem",
  wield_image = "end_him_rightly_pommel.png",
  inventory_image = "end_him_rightly_pommel.png",
  on_drop = function(itemstack, user, pointed_thing)
    if user:is_player() then
      local pos = user:get_pos()
      pos.y = pos.y + user:get_properties().eye_height
      local projectile = minetest.add_item(pos, "end_him_rightly:pommel")
      projectile:set_velocity(user:get_look_dir():multiply(20))
      return ItemStack() -- Remove from inventory
    end
  end
})

for tool, pommelless in pairs(supportedTools) do
  local toolDef = minetest.registered_tools[tool]
  if toolDef then
    toolDef = table.copy(toolDef)
    toolDef.description = "Pommelless " .. toolDef.description
    toolDef.visual = "wielditem"
    toolDef.wield_image = pommelless:gsub(":", "_") .. ".png"
    toolDef.inventory_image = toolDef.wield_image
    minetest.register_tool(pommelless, toolDef)

    -- Prepare to end them rightly
    minetest.register_craft({
      type = "shapeless",
      output = pommelless,
      recipe = {tool},
      replacements = {{tool, "end_him_rightly:pommel"}}
    })

    -- For when you've finished your business
    minetest.register_craft({
      type = "shapeless",
      output = tool,
      recipe = {pommelless, "end_him_rightly:pommel"}
    })
  end
end

minetest.register_on_craft(function(itemstack, player, old_craft_grid, craft_inv)
  -- Transfer wear to pommelless version
  for _, item in pairs(old_craft_grid) do
    local itemName = item:get_name()
    if supportedTools[itemName] == itemstack:get_name() then
      itemstack:set_wear(item:get_wear())
      return itemstack
    end
  end

  -- Transfer wear when screwing back on
  local pommelless = supportedTools[itemstack:get_name()]
  if pommelless then
    for _, item in pairs(old_craft_grid) do
      local itemName = item:get_name()
      if itemName == pommelless then
        itemstack:set_wear(item:get_wear())
        return itemstack
      end
    end
  end
end)

-- It's pommelin' time
minetest.register_globalstep(function(dtime)
  local entities = {}

  -- Find collidable entities
  for _, ref in pairs(minetest.object_refs) do
    local head = ref:get_pos()
    local prop = ref:get_properties()
    if prop then
      if prop.eye_height then
        head.y = head.y + prop.eye_height
      end
      if head and prop.collide_with_objects then
        entities[ref] = head
      end
    end
  end

  -- Primitive pommel collisions
  for _, item in pairs(minetest.luaentities) do
    if item.itemstring == "end_him_rightly:pommel" and item.age > .2 then
      local velocity = item.object:get_velocity()
      if velocity and velocity:length() > 10 then
        local pos = item.object:get_pos()
        for player, playerPos in pairs(entities) do
          if playerPos:distance(pos) < .5 then -- This distance is very arbitrary
            -- Note: Puncher should probably instead be based on the thrower 
            player:punch(player, 0, {
              full_punch_interval = 0,
              damage_groups = {
                fleshy = velocity:length() * 0.25
              }
            }, velocity:normalize():multiply(-1))
            item.object:set_velocity(vector.new(0, 0, 0))
          end
        end
      end
    end
  end
end)
