# Giad

Library for building walking vehicles.

The optional dependency on boats is only required if you want to play around with the testing entity (giad:testbed), this is because the testbed currently uses the boat model as a placeholder.

### How to use
See test_entities.lua for more details.

The general idea of the library is that all it does is provide a set of default functions and values to use in entity registration. Therefore, there is nothing special about entity registration aside from using setmetatable to inherit behaviour from giad.meta.

```lua
minetest.register_entity("foobar:walkingthing", setmetatable({
	--This is just standard entity definition
	initial_properties = {
		visual = "mesh",
		mesh = "boats_boat.obj",
	},

	--_legSpec is one of the custom fields used by giad.meta's functions
	_legSpec = {
		{vector.new(1, 0, 1), vector.new(4, -3, 5), "foobar:upperleg", "foobar:lowerleg"},
		-- ...
	}
}, giad.meta))
```

Because this uses metatables, if you override one of the functions it provides, you are in charge of ensuring any required code in the overriden method still runs. For example, if you override on_step, you should make sure to call giad.meta.on_step so that it still runs.


## A note regarding models
Both leg parts face the knee, with the upper and lower legs having origins at the "hip" and foot, respectively.
