--First, it is necessary to register the entities that will be used by the legs.
--These are just standard entity definitions
minetest.register_entity("giad:leg_upper", {
	initial_properties = {
		visual = "mesh",
		mesh = "giad_leg_upper.obj",
	},
	textures = { "giad_testure.png" },
	static_save = false, --All leg components should have this to make them ephemeral
})

minetest.register_entity("giad:leg_lower", {
	initial_properties = {
		visual = "mesh",
		mesh = "giad_leg_lower.obj",
	},
	textures = { "giad_testure.png" },
	static_save = false,
})

minetest.register_entity("giad:testbed", setmetatable({
	initial_properties = {
		visual = "mesh",
		mesh = "giad_testbed_body.obj",
	},
	textures = { "giad_testure.png" },
	physical = true,

	_createLegs = function(self)
		--This function uses some for loops, but the gist is just to initialize the _legs table.
		local function newLeg(from, to)
			return setmetatable({
				offset = from,
				restPos = to,
				upper = "giad:leg_upper",
				lower = "giad:leg_lower",
				upperLength = 3,
				lowerLength = 4,
			}, giad.leg)
		end

		self._legs = {}

		for i = 1, 4 do
			local angle = vector.new(0, i * math.pi / 5, 0)
			self._legs[i * 2 - 1] = newLeg(vector.new(0, 0, 1):rotate(angle), vector.new(0, -3, 6):rotate(angle))
			self._legs[i * 2] = newLeg(vector.new(0, 0, 1):rotate(-angle), vector.new(0, -3, 6):rotate(-angle))
		end
	end,
	_maxStepping = 3,
	_canJump = true
}, giad.meta))


--This section is a hacky way to make bipeds.
--A proper way to do this will eventually exist.

local bipedLeg = {} -- Create a class inheriting from giad.leg
bipedLeg.__index = bipedLeg

local forwardsVector = vector.new(0, 0, 1)

--Wrap the reposition function so the knees face forward...
function bipedLeg:update(dtime, parent, attachment)
	if not self.target then
		self.target = attachment
	end
	local up = forwardsVector:rotate(parent:get_rotation())
	self:reposition(dtime, attachment, up)
	self.stepping = self.interpolation ~= nil
end

setmetatable(bipedLeg, giad.leg)

minetest.register_entity("giad:biped", setmetatable({
	initial_properties = {
		visual = "mesh",
		mesh = "giad_biped_body.obj",
	},
	textures = { "giad_testure.png" },
	physical = true,

	_createLegs = function(self)
		--This function uses some for loops, but the gist is just to initialize the _legs table.
		local function newLeg(from, to)
			return setmetatable({
				offset = from,
				restPos = to,
				upper = "giad:leg_upper",
				lower = "giad:leg_lower",
				upperLength = 3,
				lowerLength = 4,
				force = 5
			}, bipedLeg)
		end

		self._legs = {
			newLeg(vector.new(1, 0, 0), vector.new(0, -6, 0)),
			newLeg(vector.new(-1, 0, 0), vector.new(0, -6, 0)),
		}
	end,
	_maxStepping = 1,
	_canJump = true
}, giad.meta))
