local grenadeDuration = 10
local gravity = 9.8

minetest.register_entity("splooshy_bombs_grenade:grenade_entity", {
  initial_properties = {
    visual = "sprite",
    textures = {"splooshy_bombs_grenade_pulled.png"}
  },
  _age = 0,
  _last_pos = false,
  on_step = function(self, dtime, moveresult)
    self._age = self._age + dtime
    local obj = self.object
    if not obj then
      return
    end

    if self._age > grenadeDuration then
      splooshy_bombs.boom(obj:get_pos(), 4, 50, nil, 0, true, true)
      obj:remove()
      return
    end

    obj:add_velocity(vector.new(0, -gravity * dtime, 0))

    local current_pos = obj:get_pos()
    if not self._last_pos then -- Fallback to approximation if not available
      self._last_pos = current_pos:subtract(obj:get_velocity() * dtime)
    end
    -- Slight offset backwards in an attempt to reduce phasing
    local last_pos = self._last_pos:add(obj:get_velocity():normalize():multiply(0.1))
    self._last_pos = current_pos

    local hit = Raycast(last_pos, current_pos, false, true):next()
    if hit then
      splooshy_bombs.boom(hit.under or current_pos, 4, {
        damage = 50,
        damage_radius = 8,
        vaporize = false
      })
      obj:remove()
    end
  end
})

minetest.register_tool("splooshy_bombs_grenade:grenade", {
  description = "Grenade",
  visual = "wielditem",
  inventory_image = "splooshy_bombs_grenade.png",
  on_use = function(itemstack, user, pointed_thing)
    local entity = minetest.add_entity(user:get_pos():offset(0, user:get_properties().eye_height, 0),
        "splooshy_bombs_grenade:grenade_entity", nil)
    if entity then
      entity:set_velocity(user:get_velocity():add(user:get_look_dir():multiply(30)))
    end
    if not (minetest.check_player_privs(user, "creative")) then
      return ItemStack()
    end
  end
})

minetest.register_craft({
  output = "splooshy_bombs_grenade:grenade",
  recipe = {{"fire:flint_and_steel"}, {"tnt:tnt_stick"}}
})
