splooshy_bombs = {
  drop_percent = 50, -- chance of nodes at edge dropping/vaporizing
  respect_protection = true, -- If true, leave protected areas untouched (untested)
  vaporize = true -- If true, don't drop items (some drops from falling nodes may still occur)
}

local random = PcgRandom(0)

-- user: string username
-- Warning: Calling with nil user will ignore protection.
-- Some arguments support using nil to use the default behaviour
function splooshy_bombs.boom(location, radius, damage, user, drop_percent, respect_protection, vaporize)
  if drop_percent == nil then
    drop_percent = splooshy_bombs.drop_percent
  end
  if respect_protection == nil then
    respect_protection = splooshy_bombs.respect_protection
  end
  if vaporize == nil then
    vaporize = vaporize or splooshy_bombs.vaporize
  end

  if damage then
    for _, entity in pairs(minetest.get_objects_inside_radius(location, radius)) do
      if entity:is_player() then
        entity:punch(user, 0, {
          full_punch_interval = 0,
          damage_groups = {
            fleshy = damage / (entity:get_pos():distance(location) + 1)
          }
        }, direction)
      end
    end
  end

  -- Break/fling blocks
  for y = location.y + radius, location.y - radius, -1 do -- Reversed to avoid issues with falling blocks
    for x = location.x - radius, location.x + radius do
      for z = location.z - radius, location.z + radius do
        local coord = vector.new(x, y, z)
        local delta = coord:subtract(location)
        local distance = delta:length()
        if distance <= radius and (not (user and respect_protection and minetest.is_protected(coord, user))) then
          if random:next(1, 100) * distance <= drop_percent * radius then
            if vaporize then
              minetest.set_node(coord, {
                name = "air"
              })
            else
              minetest.dig_node(coord)
            end
          else
            local ok, node = minetest.spawn_falling_node(coord)
            if ok then
              node:set_properties({
                collide_with_objects = false
              })
              if distance > 0 then
                local explosion_velocity = delta:normalize():multiply(2 * (radius + 1) / (distance + 1))
                node:set_velocity(explosion_velocity:offset(random:rand_normal_dist(-2, 2), random:rand_normal_dist(-2,
                    2) + (10 * (radius + 1) / (distance + 1)), random:rand_normal_dist(-2, 2)))
                local newPos = coord:subtract(delta:normalize() / 2)
                node:set_pos(newPos)
              end
            end
          end
        end
      end
    end
  end
end

minetest.register_tool("splooshy_bombs_api:teststick", {
  description = "Splooshy Bombs test stick",
  visual = "wielditem",
  inventory_image = "splooshy_bombs_api_teststick.png",
  on_use = function(itemstack, user, pointed_thing)
    if pointed_thing and pointed_thing.under then
      splooshy_bombs.boom(pointed_thing.under, 10, 0, user)
    end
  end
})
