-- Función para desbloquear el permiso de vuelo del jugador
local function desbloquear_vuelo(player)
    if not player or not player:is_player() then
        return
    end
    local name = player:get_player_name()
    -- Obtener privilegios actuales
    local privs = minetest.get_player_privs(name)
    -- Dar permiso de vuelo si no lo tiene
    if not privs.fly then
        privs.fly = true
        minetest.set_player_privs(name, privs)
        minetest.chat_send_player(name, "¡Permiso de vuelo desbloqueado!")
    end
end

-- Función que se ejecuta al usar el ítem
local function on_item_use(itemstack, user, pointed_thing)
    -- Desbloquear vuelo
    desbloquear_vuelo(user)
    -- Consumir el ítem (hacer que desaparezca)
    itemstack:take_item()
    return itemstack
end

-- Registro del ítem jetpack
minetest.register_tool("jetpack_fly:jetpack", {
    description = "Jetpack",
    inventory_image = "jetpack.png",
    on_use = on_item_use,
    stack_max = 1, -- No se puede apilar
})

-- Receta para fabricar el jetpack
minetest.register_craft({
    output = "jetpack_fly:jetpack",
    recipe = {
        {"default:steel_ingot", "default:glass", "default:steel_ingot"},
        {"default:steel_ingot", "default:mese", "default:steel_ingot"},
        {"", "default:steel_ingot", ""},
    }
})
