-- OreControl
-- Fully configurable ore generation system

local enable = minetest.settings:get_bool("orecontrol_enable", true)
if not enable then
    return
end

local preset = minetest.settings:get("orecontrol_preset") or "balanced"

local function get_int(name, default)
    return tonumber(minetest.settings:get(name)) or default
end

local function get_bool(name, default)
    return minetest.settings:get_bool(name, default)
end

local function apply_preset(scarcity)
    if preset == "rich" then
        return math.max(1, scarcity - 3)
    elseif preset == "scarce" then
        return scarcity + 5
    else
        return scarcity
    end
end

local function register_ore(id, node)

    if not get_bool("orecontrol_" .. id .. "_enable", true) then
        return
    end

    local scarcity = get_int("orecontrol_" .. id .. "_scarcity", 10)
    scarcity = apply_preset(scarcity)

    local num = get_int("orecontrol_" .. id .. "_num", 10)
    local size = get_int("orecontrol_" .. id .. "_size", 4)
    local ymax = get_int("orecontrol_" .. id .. "_ymax", 64)
    local ymin = get_int("orecontrol_" .. id .. "_ymin", -31000)

    minetest.register_ore({
        ore_type       = "scatter",
        ore            = node,
        wherein        = "default:stone",
        clust_scarcity = scarcity * scarcity * scarcity,
        clust_num_ores = num,
        clust_size     = size,
        y_max          = ymax,
        y_min          = ymin,
    })

    minetest.log("action", "[OreControl] Registered: " .. id)
end

-- We DO NOT clear other mod ores

register_ore("coal", "default:stone_with_coal")
register_ore("iron", "default:stone_with_iron")
register_ore("copper", "default:stone_with_copper")
register_ore("gold", "default:stone_with_gold")
register_ore("diamond", "default:stone_with_diamond")
register_ore("mese", "default:stone_with_mese")
