-- VoxeLibre Fries mod.
-- Inspired by my brother's suggestion (thanks, Filip).
-- Enriched with my children's ideas.
-- Addon for mcl_farming by PilzAdam and VoxeLibre Dev Team.
-- Thank You all.
-- Created: 2025-07-07
-- Updated: 2025-08-20
-- Internal version: 1.2.250820
-- License for Code: GPL-3.0-or-later
-- License for Media: CC-BY-SA-4.0
-- Copyright (C) 2025, ems111 (Kamil Przychodzeń). See: License.txt.

local S = core.get_translator(core.get_current_modname())

--		#######    ######   ##    #
--		##     #  ##     #   ##  #
--		##     #  ##     #    ###
--		#######   ##     #     ##
--		##     #  ##     #    # ##
--		##     #  ##     #   #   ##
--		#######    ######   #     ##

core.register_craftitem("vl_fries:empty_box", {
	description = S("Empty Box"),
	inventory_image = "vl_fries_empty_box.png",
	groups = {compostability = 35},
	stack_max = 64,
})

core.register_craft({
	output = "vl_fries:empty_box 2",
	recipe = {
		{"mcl_core:paper", "", "mcl_core:paper"},
		{"mcl_dye:red", "mcl_core:paper", "mcl_dye:red"},
	},
})

core.register_craft({
	output = "mcl_core:paper 3",
	recipe = {
		{"vl_fries:empty_box", "vl_fries:empty_box", "vl_fries:empty_box"},
		{"vl_fries:empty_box", "vl_fries:empty_box", "vl_fries:empty_box"},
		{"vl_fries:empty_box", "vl_fries:empty_box", "vl_fries:empty_box"},
	},
})

core.register_craft({
	type = "fuel",
	recipe = "vl_fries:empty_box",
	burntime = 4,
})

--		######   ######   ######  ##     #   ######   ##     #
--		##      ##     #  ##      ###    #  ##     #  ##     #
--		##      ##     #  ##      ## #   #  ##        ##     #
--		####    #######   ####    ##  #  #  ##        ########
--		##      ##   #    ##      ##   # #  ##        ##     #
--		##      ##    #   ##      ##    ##  ##     #  ##     #
--		##      ##     #  ######  ##     #   ######   ##     #

core.register_craftitem("vl_fries:raw_fries", {
	description = S("Raw Fries"),
	inventory_image = "vl_fries_raw_fries.png",
	groups = {food = 2, eatable = 1, compostability = 65},
	_mcl_saturation = 0.6,
	stack_max = 64,
	on_secondary_use = core.item_eat(1),
	on_place = core.item_eat(1),
})

core.register_craftitem("vl_fries:roasted_fries", {
	description = S("Roasted Fries"),
	inventory_image = "vl_fries_roasted_fries.png",
	groups = {food=2, eatable=5},
	_mcl_saturation = 4,
	stack_max = 64,
	on_secondary_use = core.item_eat(5),
	on_place = core.item_eat(5),
})

core.register_craftitem("vl_fries:fries_box", {
	description = S("Fries Box"),
	inventory_image = "vl_fries_fries_box.png",
	groups = {food=2, eatable=10},
	stack_max = 1,
	_mcl_saturation = 6,
	on_place = core.item_eat(10, "vl_fries:empty_box"),
	on_secondary_use = core.item_eat(10, "vl_fries:empty_box"),
})

core.register_craft({
	output = "vl_fries:raw_fries 3",
	recipe = {
		{"mcl_farming:potato_item", "mcl_farming:potato_item", "mcl_farming:potato_item"}
	},
})

core.register_craft({
	type = "cooking",
	output = "vl_fries:roasted_fries",
	recipe = "vl_fries:raw_fries",
	cooktime = 10,
})

core.register_craft({
	type = "shapeless",
	output = "vl_fries:fries_box",
	recipe = {"vl_fries:roasted_fries", "vl_fries:roasted_fries", "vl_fries:empty_box"},
})

--		#######   ######  ##       ######   ##   ######   ##     #
--		##     #  ##      ##      ##        ##  ##     #  ###    # 
--		##     #  ##      ##      ##        ##  ##     #  ## #   #
--		#######   ####    ##      ##        ##  ##  ####  ##  #  #
--		##     #  ##      ##      ##   ###  ##  ##     #  ##   # #
--		##     #  ##      ##      ##     #  ##  ##     #  ##    ##
--		#######   ######  ######   ######   ##  ##     #  ##     #

core.register_craftitem("vl_fries:raw_belgian_fries", {
	description = S("Raw Belgian Fries"),
	inventory_image = "vl_fries_raw_belgian_fries.png",
	groups = {food = 2, eatable = 1, compostability = 65},
	_mcl_saturation = 0.6,
	stack_max = 64,
	on_secondary_use = core.item_eat(1),
	on_place = core.item_eat(1),
})

 -- FIRST STAGE
core.register_craftitem("vl_fries:first_stage_belgian_fries", {
	description = S("Belgian Fries - First stage of frying"),
	_tt_help = core.colorize("#FFFF55", S("To make them ready to eat, bake them in the furnace again.")),
	inventory_image = "vl_fries_belgian_fries_first_stage.png",
	groups = {food=2, eatable=1},
	_mcl_saturation = 0.7,
	stack_max = 64,
	on_secondary_use = core.item_eat(1),
	on_place = core.item_eat(1),
})

 -- SECOND STAGE
core.register_craftitem("vl_fries:roasted_belgian_fries", {
	description = S("Roasted Belgian Fries"),
	inventory_image = "vl_fries_roasted_belgian_fries.png",
	groups = {food=2, eatable=5},
	_mcl_saturation = 4,
	stack_max = 64,
	on_secondary_use = core.item_eat(5),
	on_place = core.item_eat(5),
})

core.register_craftitem("vl_fries:belgian_fries_box", {
	description = S("Belgian Fries Box"),
	inventory_image = "vl_fries_belgian_fries_box.png",
	groups = {food=2, eatable=10},
	stack_max = 1,
	_mcl_saturation = 6,
	on_place = core.item_eat(10, "vl_fries:empty_box"),
	on_secondary_use = core.item_eat(10, "vl_fries:empty_box"),
})

core.register_craft({
	output = "vl_fries:raw_belgian_fries 6",
	recipe = {
		{"mcl_farming:potato_item", "mcl_farming:potato_item", "mcl_farming:potato_item"},
		{"mcl_farming:potato_item", "mcl_farming:potato_item", "mcl_farming:potato_item"}
	},
})

 -- FIRST STAGE
core.register_craft({
	type = "cooking",
	output = "vl_fries:first_stage_belgian_fries",
	recipe = "vl_fries:raw_belgian_fries",
	cooktime = 8,
})

-- SECOND STAGE
core.register_craft({ 
	type = "cooking",
	output = "vl_fries:roasted_belgian_fries",
	recipe = "vl_fries:first_stage_belgian_fries",
	cooktime = 6,
})

core.register_craft({
	type = "shapeless",
	output = "vl_fries:belgian_fries_box",
	recipe = {"vl_fries:roasted_belgian_fries", "vl_fries:roasted_belgian_fries", "vl_fries:empty_box"},
})

--		#######    ######   ##   ######    ######   ##     #   ######   ##     #   ###### 
--		##     #  ##     #  ##  ##     #  ##     #  ###    #  ##     #  ##     #  ##     #
--		##     #  ##     #  ##  ##        ##     #  ## #   #  ##     #  ##     #  ##      
--		#######   ##     #  ##   ######   ##     #  ##  #  #  ##     #  ##     #   ###### 
--		##        ##     #  ##         #  ##     #  ##   # #  ##     #  ##     #         #
--		##        ##     #  ##  ##     #  ##     #  ##    ##  ##     #  ##     #  ##     #
--		##         ######   ##   ######    ######   ##     #   ######    ######    ###### 

core.register_craftitem("vl_fries:raw_fries_poison", {
	description = S("Poisonous Raw Fries"),
	_tt_help = core.colorize("#FFFF55", S("60% chance of poisoning")),
	inventory_image = "vl_fries_raw_fries_poison.png",
	groups = {food = 2, eatable = 1},
	_mcl_saturation = 0.2,
	stack_max = 64,
	on_secondary_use = core.item_eat(1),
	on_place = core.item_eat(1),
})

core.register_craftitem("vl_fries:roasted_fries_poison", {
	description = S("Poisonous Roasted Fries"),
	_tt_help = core.colorize("#FFFF55", S("60% chance of poisoning")),
	inventory_image = "vl_fries_roasted_fries_poison.png",
	groups = {food=2, eatable=2},
	_mcl_saturation = 2,
	stack_max = 64,
	on_secondary_use = core.item_eat(2),
	on_place = core.item_eat(2),
})

core.register_craftitem("vl_fries:fries_box_poison", {
	description = S("Poisonous Fries Box"),
	_tt_help = core.colorize("#FFFF55", S("60% chance of poisoning")),
	inventory_image = "vl_fries_fries_box_poison.png",
	groups = {food=2, eatable=5},
	stack_max = 1,
	_mcl_saturation = 3,
	on_place = core.item_eat(5, "vl_fries:empty_box"),
	on_secondary_use = core.item_eat(5, "vl_fries:empty_box"),
})

core.register_craft({
	output = "vl_fries:raw_fries_poison 3",
	recipe = {
		{"mcl_farming:potato_item_poison", "mcl_farming:potato_item_poison", "mcl_farming:potato_item_poison"}
	},
})

core.register_craft({
	type = "cooking",
	output = "vl_fries:roasted_fries_poison",
	recipe = "vl_fries:raw_fries_poison",
	cooktime = 10,
})

core.register_craft({
	type = "shapeless",
	output = "vl_fries:fries_box_poison",
	recipe = {"vl_fries:roasted_fries_poison", "vl_fries:roasted_fries_poison", "vl_fries:empty_box"},
})

core.register_on_item_eat(function (hp_change, replace_with_item, itemstack, user, pointed_thing)
	-- 60% chance of poisoning
	if itemstack:get_name() == "vl_fries:raw_fries_poison" or itemstack:get_name() == "vl_fries:roasted_fries_poison" or itemstack:get_name() == "vl_fries:fries_box_poison" then
		if math.random(1,10) >= 6 then
			mcl_potions.give_effect_by_level("poison", user, 1, 5)
		end
	end
end)

-- Bon appetit!