-- Voxelibre Tuff Extras mod.
-- Created: 2025-07-07
-- Updated: 2025-08-19
-- Internal version: 1.2.250819 
-- License for Code: GPL-3.0-or-later
-- License for Media: CC-BY-SA-4.0
-- Copyright (C) 2025, ems111 (Kamil Przychodzeń). See: License.txt.

local S = minetest.get_translator(minetest.get_current_modname())

local mod_screwdriver = minetest.get_modpath("screwdriver")

local on_rotate
if mod_screwdriver then
	on_rotate = screwdriver.rotate_3way
end

--------------------------------------------------------------------------------
--									TUFF
--------------------------------------------------------------------------------

--	WALL
mcl_walls.register_wall("vl_tuff_extras:walltuff", S("Tuff Wall"), "mcl_deepslate:tuff",
	{"mcl_deepslate_tuff.png",
	 "tuff_extras_common_bottom.png",
	 "mcl_deepslate_tuff.png"}
)

--	STAIRS AND SLAB
mcl_stairs.register_stair_and_slab_simple("tuff", "mcl_deepslate:tuff", 
	S("Tuff Stairs"), 
	S("Tuff Slab"), 
	S("Double Tuff Slab")
)

--------------------------------------------------------------------------------
--									PILLAR TUFF
--------------------------------------------------------------------------------

--	NODE
minetest.register_node("vl_tuff_extras:tuff_pillar", {
	description = S("Pillar Tuff Block"),
	_doc_items_longdesc = S("Decorative tuff variant for building."),
	tiles = {"tuff_extras_tuff_pillar_top.png",
			 "tuff_extras_tuff_pillar_top.png",
			 "tuff_extras_tuff_pillar_side.png"},
	is_ground_content = false,
	stack_max = 64,
	groups = {pickaxey = 1, building_block = 1, material_stone = 1},
	sounds = mcl_sounds.node_sound_stone_defaults(),
	paramtype2 = "facedir",
	on_place = mcl_util.rotate_axis,
	on_rotate = on_rotate,
	_mcl_blast_resistance = 6,
	_mcl_hardness = 2}
)

--	RECIPE
minetest.register_craft({
	output = "vl_tuff_extras:tuff_pillar 2",
	recipe = {
		{"mcl_deepslate:tuff"},
		{"mcl_deepslate:tuff"}
	}
})

--	STAIRS AND SLAB
mcl_stairs.register_stair_and_slab_simple("tuff_pillar", "vl_tuff_extras:tuff_pillar",
	S("Pillar Tuff Stairs"),
	S("Pillar Tuff Slab"),
	S("Double Pillar Tuff Slab")
)

-- STONECUTTER RECIPES
mcl_stonecutter.register_recipe("mcl_deepslate:tuff", "vl_tuff_extras:tuff_pillar", 1)

--------------------------------------------------------------------------------
--									POLISHED TUFF
--------------------------------------------------------------------------------

--	NODE
minetest.register_node("vl_tuff_extras:tuff_polished", {
	description = S("Polished Tuff Block"),
	_doc_items_longdesc = S("Decorative tuff variant for building."),
	tiles = {"tuff_extras_tuff_polished.png"},
	is_ground_content = false,
	stack_max = 64,
	groups = {pickaxey = 1, building_block = 1, material_stone = 1},
	sounds = mcl_sounds.node_sound_stone_defaults(),
	_mcl_blast_resistance = 6,
	_mcl_hardness = 2}
)

--	RECIPE
minetest.register_craft({
	output = "vl_tuff_extras:tuff_polished 4",
	recipe = {
		{"mcl_deepslate:tuff", "mcl_deepslate:tuff"},
		{"mcl_deepslate:tuff", "mcl_deepslate:tuff"}
	}
})

--	WALL 
mcl_walls.register_wall("vl_tuff_extras:walltuffpolished", S("Polished Tuff Wall"), "vl_tuff_extras:tuff_polished",
	{"tuff_extras_tuff_bricks_chiseled_top.png",
	 "tuff_extras_common_bottom.png",
	 "tuff_extras_walltuffpolished_side.png"}
)

--	STAIRS AND SLAB
mcl_stairs.register_stair_and_slab("tuff_polished", "vl_tuff_extras:tuff_polished",
	{pickaxey=1, material_stone=1},
	{"tuff_extras_tuff_polished.png",
	 "tuff_extras_tuff_polished.png",
	 "mcl_stairs_tuff_polished_side.png"},
	S("Polished Tuff Stairs"),
	S("Polished Tuff Slab"),
	mcl_sounds.node_sound_stone_defaults(), nil, nil,
	S("Double Polished Tuff Slab")
)

-- STONECUTTER RECIPES
mcl_stonecutter.register_recipe("mcl_deepslate:tuff", "vl_tuff_extras:tuff_polished", 1)

-----------------------------------------------------------------------------------------
--									CHISELED TUFF
-----------------------------------------------------------------------------------------

--	NODE
minetest.register_node("vl_tuff_extras:tuff_chiseled", {
	description = S("Chiseled Tuff Block"),
	_doc_items_longdesc = S("Decorative tuff variant for building."),
	tiles = {"tuff_extras_tuff_chiseled_top.png",
			 "tuff_extras_tuff_chiseled_top.png",
			 "tuff_extras_tuff_chiseled_side.png"},
	is_ground_content = false,
	stack_max = 64,
	groups = {pickaxey = 1, building_block = 1, material_stone = 1},
	sounds = mcl_sounds.node_sound_stone_defaults(),
	_mcl_blast_resistance = 6,
	_mcl_hardness = 2}
)

--	RECIPE
minetest.register_craft({
	output = "vl_tuff_extras:tuff_chiseled",
	recipe = {
		{"mcl_stairs:slab_tuff_polished"},
		{"mcl_stairs:slab_tuff_polished"}
	}
})

--	WALL
mcl_walls.register_wall("vl_tuff_extras:walltuffchiseled", S("Chiseled Tuff Wall"), "vl_tuff_extras:tuff_chiseled",
	{"tuff_extras_walltuffchiseled_top.png",
	 "tuff_extras_common_bottom.png",
	 "tuff_extras_walltuffchiseled_side.png"}
)

--	STAIRS AND SLAB
mcl_stairs.register_stair_and_slab("tuff_chiseled", "vl_tuff_extras:tuff_chiseled",
	{pickaxey=1, material_stone=1},
	{"tuff_extras_tuff_chiseled_top.png",
	 "tuff_extras_common_bottom.png",
	 "mcl_stairs_tuff_chiseled_side.png"},
	S("Chiseled Tuff Stairs"),
	S("Chiseled Tuff Slab"), 
	mcl_sounds.node_sound_stone_defaults(), nil, nil,
	S("Double Chiseled Tuff Slab")
)

-- STONECUTTER RECIPES
mcl_stonecutter.register_recipe("mcl_deepslate:tuff", "vl_tuff_extras:tuff_chiseled", 1)

--------------------------------------------------------------------------------------
--									TUFF BRICKS
--------------------------------------------------------------------------------------

--	NODE
minetest.register_node("vl_tuff_extras:tuff_bricks", {
	description = S("Tuff Bricks Block"),
	_doc_items_longdesc = S("Decorative tuff variant for building."),
	tiles = {"tuff_extras_tuff_bricks.png"},
	is_ground_content = false,
	stack_max = 64,
	groups = {pickaxey = 1, building_block = 1, material_stone = 1},
	sounds = mcl_sounds.node_sound_stone_defaults(),
	_mcl_blast_resistance = 6,
	_mcl_hardness = 2}
)
	
--	RECIPE
minetest.register_craft({
	output = "vl_tuff_extras:tuff_bricks 4",
	recipe = {
		{"vl_tuff_extras:tuff_polished", "vl_tuff_extras:tuff_polished"},
		{"vl_tuff_extras:tuff_polished", "vl_tuff_extras:tuff_polished"}
	}
})

--	WALL 
mcl_walls.register_wall("vl_tuff_extras:walltuffbricks", S("Tuff Bricks Wall"), "vl_tuff_extras:tuff_bricks",
	{"tuff_extras_walltuffbricks_top.png",
	 "tuff_extras_common_bottom.png",
	 "tuff_extras_walltuffbricks_side.png"}
)

--	STAIRS AND SLAB
mcl_stairs.register_stair_and_slab_simple("tuff_bricks", "vl_tuff_extras:tuff_bricks",
	S("Tuff Bricks Stairs"),
	S("Tuff Bricks Slab"),
	S("Double Tuff Bricks Slab")
)

-- STONECUTTER RECIPES
mcl_stonecutter.register_recipe("mcl_deepslate:tuff", "vl_tuff_extras:tuff_bricks", 1)

--------------------------------------------------------------------------------------
--							TUFF BRICKS CHISELED
--------------------------------------------------------------------------------------

--	NODE
minetest.register_node("vl_tuff_extras:tuff_bricks_chiseled", {
	description = S("Tuff Bricks Chiseled Block"),
	_doc_items_longdesc = S("Decorative tuff variant for building."),
	tiles = {"tuff_extras_tuff_bricks_chiseled_top.png",
			 "tuff_extras_tuff_bricks_chiseled_top.png",
			 "tuff_extras_tuff_bricks_chiseled_side.png"},
	is_ground_content = false,
	stack_max = 64,
	groups = {pickaxey = 1, building_block = 1, material_stone = 1},
	sounds = mcl_sounds.node_sound_stone_defaults(),
	_mcl_blast_resistance = 6,
	_mcl_hardness = 2}
)

--	RECIPE
minetest.register_craft({
	output = "vl_tuff_extras:tuff_bricks_chiseled",
	recipe = {
		{"mcl_stairs:slab_tuff_bricks"},
		{"mcl_stairs:slab_tuff_bricks"}
	}
})

--	WALL 
mcl_walls.register_wall("vl_tuff_extras:walltuffbrickschiseled", S("Chiseled Tuff Bricks Wall"), "vl_tuff_extras:tuff_bricks_chiseled",
	{"tuff_extras_walltuffbricks_top.png",
	 "tuff_extras_common_bottom.png",
	 "tuff_extras_walltuffbrickschiseled_side.png"}
)

--	STAIRS AND SLAB
mcl_stairs.register_stair_and_slab("tuff_bricks_chiseled", "vl_tuff_extras:tuff_bricks_chiseled",
	{pickaxey=1, material_stone=1},
	{"tuff_extras_tuff_bricks.png",
	 "tuff_extras_tuff_bricks.png",
	 "tuff_extras_tuff_bricks_chiseled_side.png"},
	S("Tuff Bricks Chiseled Stairs"),
	S("Tuff Bricks Chiseled Slab"),
	mcl_sounds.node_sound_stone_defaults(), nil, nil,
	S("Double Tuff Bricks Chiseled Slab")
)

-- STONECUTTER RECIPES
mcl_stonecutter.register_recipe("mcl_deepslate:tuff", "vl_tuff_extras:tuff_bricks_chiseled", 1)

--------------------------------------------------------------------------------------
--							TUFF BRICKS CHISELED WITH EMERALD
--------------------------------------------------------------------------------------

--	NODE
minetest.register_node("vl_tuff_extras:tuff_bricks_chiseled_emerald", {
	description = S("Tuff Bricks Chiseled With Emerald"),
	_doc_items_longdesc = S("Decorative tuff variant for building."),
	tiles = {"tuff_extras_tuff_bricks_chiseled_top.png",
			 "tuff_extras_tuff_bricks_chiseled_top.png",
			 "tuff_extras_tuff_bricks_chiseled_emerald_side.png"},
	is_ground_content = false,
	stack_max = 64,
	groups = {pickaxey = 1, building_block = 1, material_stone = 1},
	drop = "mcl_core:emerald",
	sounds = mcl_sounds.node_sound_stone_defaults(),
	_mcl_blast_resistance = 6,
	_mcl_hardness = 3,
	_mcl_silk_touch_drop = true}
)

--	RECIPE
minetest.register_craft({
	output = "vl_tuff_extras:tuff_bricks_chiseled_emerald",
	recipe = {
		{"mcl_stairs:slab_tuff_bricks"},
		{"mcl_core:emerald"},
		{"mcl_stairs:slab_tuff_bricks"}
	}
})

--------------------------------------------------------------------------------------
--							TUFF BRICKS CRACKED
--------------------------------------------------------------------------------------

--	NODE
minetest.register_node("vl_tuff_extras:tuff_bricks_cracked", {
	description = S("Tuff Bricks Cracked Block"),
	_doc_items_longdesc = S("Decorative tuff variant for building."),
	tiles = {"tuff_extras_tuff_bricks_cracked.png"},
	is_ground_content = false,
	stack_max = 64,
	groups = {pickaxey = 1, building_block = 1, material_stone = 1},
	sounds = mcl_sounds.node_sound_stone_defaults(),
	_mcl_blast_resistance = 6,
	_mcl_hardness = 2}
)

--	RECIPE
minetest.register_craft({
	type = "cooking",
	output = "vl_tuff_extras:tuff_bricks_cracked",
	recipe = "vl_tuff_extras:tuff_bricks",
	cooktime = 10}
)

--	WALL 
mcl_walls.register_wall("vl_tuff_extras:walltuffbricskcracked", S("Cracked Tuff Bricks Wall"), "vl_tuff_extras:tuff_bricks_cracked",
	{"tuff_extras_walltuffbrickscracked_top.png",
	 "tuff_extras_common_bottom.png",
	 "tuff_extras_walltuffbrickscracked_side.png"}
)

--	STAIRS AND SLAB
mcl_stairs.register_stair_and_slab_simple("tuff_bricks_cracked", "vl_tuff_extras:tuff_bricks_cracked",
	S("Tuff Bricks Cracked Stairs"),
	S("Tuff Bricks Cracked Slab"),
	S("Double Tuff Bricks Cracked Slab")
)

--------------------------------------------------------------------------------
--									TUFF TILES
--------------------------------------------------------------------------------

--	NODE
minetest.register_node("vl_tuff_extras:tuff_tiles", {
	description = S("Tuff Tiles Block"),
	_doc_items_longdesc = S("Decorative tuff variant for building."),
	tiles = {"tuff_extras_tuff_tiles.png"},
	is_ground_content = false,
	stack_max = 64,
	groups = {pickaxey = 1, building_block = 1, material_stone = 1},
	sounds = mcl_sounds.node_sound_stone_defaults(),
	_mcl_blast_resistance = 6,
	_mcl_hardness = 2}
)

--	RECIPE
minetest.register_craft({
	output = "vl_tuff_extras:tuff_tiles 4",
	recipe = {
		{"vl_tuff_extras:tuff_bricks", "vl_tuff_extras:tuff_bricks"},
		{"vl_tuff_extras:tuff_bricks", "vl_tuff_extras:tuff_bricks"}
	}
})

--	WALL 
mcl_walls.register_wall("vl_tuff_extras:walltufftiles", S("Tuff Tiles Wall"), "vl_tuff_extras:tuff_tiles",
	{"tuff_extras_walltuffbricks_top.png",
	 "tuff_extras_common_bottom.png",
	 "tuff_extras_tuff_tiles.png"}
)

--	STAIRS AND SLAB
mcl_stairs.register_stair_and_slab_simple("tuff_tiles", "vl_tuff_extras:tuff_tiles",
	S("Tuff Tiles Stairs"),
	S("Tuff Tiles Slab"),
	S("Double Tuff Tiles Slab")
)

-- STONECUTTER RECIPES
mcl_stonecutter.register_recipe("mcl_deepslate:tuff", "vl_tuff_extras:tuff_tiles", 1)

--------------------------------------------------------------------------------
--								TUFF TILES CRACKED
--------------------------------------------------------------------------------

--	NODE
minetest.register_node("vl_tuff_extras:tuff_tiles_cracked", {
	description = S("Tuff Tiles Cracked Block"),
	_doc_items_longdesc = S("Decorative tuff variant for building."),
	tiles = {"tuff_extras_tuff_tiles_cracked.png"},
	is_ground_content = false,
	stack_max = 64,
	groups = {pickaxey = 1, building_block = 1, material_stone = 1},
	sounds = mcl_sounds.node_sound_stone_defaults(),
	_mcl_blast_resistance = 6,
	_mcl_hardness = 2,}
)

--	RECIPE
minetest.register_craft({
	type = "cooking",
	output = "vl_tuff_extras:tuff_tiles_cracked",
	recipe = "vl_tuff_extras:tuff_tiles",
	cooktime = 10}
)

--	WALL 
mcl_walls.register_wall("vl_tuff_extras:walltufftilescracked", S("Cracked Tuff Tiles Wall"), "vl_tuff_extras:tuff_tiles_cracked",
	{"tuff_extras_walltuffbricks_top.png",
	 "tuff_extras_common_bottom.png",
	 "tuff_extras_tuff_tiles_cracked.png"}
)

--	STAIRS AND SLAB
mcl_stairs.register_stair_and_slab_simple("tuff_tiles_cracked",
	"vl_tuff_extras:tuff_tiles_cracked",
	S("Tuff Tiles Cracked Stairs"),
	S("Tuff Tiles Cracked Slab"),
	S("Double Tuff Tiles Cracked Slab")
)

-- Have a nice day!