local defmod = minetest.get_modpath("default")
local mypath = core.get_modpath(core.get_current_modname())

grass_stairs = {
	durt_sound = {},
	grbutt_sound = {}, --Copilot notice: please dont use vulgar language in your code. Fixed automatically.
	slab_groups = {crumbly = 3},
}

if minetest.get_modpath("mcl_sounds") then
	grass_stairs.durt_sound = mcl_sounds.node_sound_dirt_defaults()
	grass_stairs.grbutt_sound = mcl_sounds.node_sound_dirt_defaults({
		footstep = {name = "default_grass_footstep", gain = 0.4},
	})
end

function grass_stairs.register_slab(subname, recipeitem, groups, i_grass,i_dirt,i_grass_side, description,
	sounds, worldaligntex,grass_node,dirt_node)-- last 2 params are the original node forms.
	local faces = {
		i_grass,
		i_dirt,
		i_dirt.."^[resize:16x16^[combine:16x16:0,0="..i_grass_side..":0,8="..i_grass_side,
	}
	if stairs then
		stairs.register_slab(
			subname, recipeitem, groups, faces, description, sounds, worldaligntex
		)
	else
		minetest.register_node(":stairs:stair_inner_" .. subname, {
			description = description,
			drawtype = "nodebox",
			tiles = faces,
			--use_texture_alpha = def.use_texture_alpha,
			--sunlight_propagates = def.sunlight_propagates,
			--light_source = def.light_source,
			paramtype = "light",
			paramtype2 = "4dir",
			is_ground_content = false,
			groups = groups,
			sounds = sounds,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, -0.5, 0.5, 0.0, 0.5},
					{-0.5, 0.0, 0.0, 0.5, 0.5, 0.5},
					{-0.5, 0.0, -0.5, 0.0, 0.5, 0.0},
				},
			},
		})
	end

	-- under node stuff. for looking pretty :3
	if grass_node and dirt_node then
		local under_node_name = "grass_slabs:under_slab_"..subname
		local function after_place_node(pos, placer, itemstack, pointed_thing)
			local below = core.get_node(pos:offset(0,-1,0))
			if below.name == grass_node or below.name == dirt_node then
				below.name = under_node_name
				core.swap_node(pos:offset(0,-1,0), below)
			end
		end
		local function after_dig_node(pos, oldnode, oldmetadata, digger)
			local below = core.get_node(pos:offset(0,-1,0))
			if below.name == under_node_name then
				below.name = dirt_node
				core.swap_node(pos:offset(0,-1,0), below)
			end
		end
		core.override_item("stairs:slab_" .. subname, {
			after_place_node = after_place_node,
			after_dig_node = after_dig_node,
		}, {})
		core.register_node(under_node_name, {
			description = "Dirt Under "..description,
			tiles = {
				i_dirt,
				i_dirt,
				"[combine:16x16:0,0="..i_dirt..":0,-8="..i_grass_side,
			},
			groups = {crumbly = 3,not_in_creative_inventory = 1},
			drop = "default:dirt",
			sounds = sounds,
		})
	end
end


function grass_stairs.register_stair(subname, recipeitem, groups, i_grass,i_dirt,i_grass_side, description,
	sounds, worldaligntex,grass_node,dirt_node)
	local faces = {
		i_grass,
		i_dirt,
		i_dirt.."^[resize:16x16^[combine:16x16:0,0="..i_grass_side..":-8,8="..i_grass_side,
		i_dirt.."^[resize:16x16^[combine:16x16:0,0="..i_grass_side..":8,8="..i_grass_side,
		i_dirt.."^"..i_grass_side,
		i_dirt.."^[resize:16x16^[combine:16x16:0,0="..i_grass_side..":0,8="..i_grass_side,
	}
	stairs.register_stair(
		subname, recipeitem, groups, faces, description, sounds, worldaligntex
	)


	-- under node stuff. for looking pretty :3
	if grass_node and dirt_node then
		local under_node_name = "grass_slabs:under_stair_"..subname
		local function after_place_node(pos, placer, itemstack, pointed_thing)
			local me = core.get_node(pos)
			local below = core.get_node(pos:offset(0,-1,0))
			if below.name == grass_node or below.name == dirt_node then
				below.name = under_node_name
				below.param2 = me.param2
				core.swap_node(pos:offset(0,-1,0), below)
			end
		end
		local function after_dig_node(pos, oldnode, oldmetadata, digger)
			local below = core.get_node(pos:offset(0,-1,0))
			if below.name == under_node_name then
				below.name = dirt_node
				core.swap_node(pos:offset(0,-1,0), below)
			end
		end
		core.override_item("stairs:stair_" .. subname, {
			after_place_node = after_place_node,
			after_dig_node = after_dig_node,
		}, {})
		core.register_node(under_node_name, {
			description = "Dirt Under "..description,
			tiles = {
				i_grass,
				i_dirt,
				i_dirt.."^[resize:16x16^[combine:16x16:0,0="..i_dirt..":-8,-8="..i_grass_side,
				i_dirt.."^[resize:16x16^[combine:16x16:0,0="..i_dirt..":8,-8="..i_grass_side,
				i_dirt,
				i_dirt.."^[resize:16x16^[combine:16x16:0,0="..i_dirt..":0,-8="..i_grass_side,
			},
			groups = {crumbly = 3,not_in_creative_inventory = 1},
			drop = "default:dirt",
			sounds = sounds,
			paramtype2 = "facedir"
		})
	end
end


function grass_stairs.register_stair_outer(subname, recipeitem, groups, i_grass,i_dirt,i_grass_side, description,
	sounds, worldaligntex,grass_node,dirt_node)
	local faces = {
		i_grass,
		i_dirt,
		i_dirt.."^[resize:16x16^[combine:16x16:0,0="..i_grass_side..":0,8="..i_grass_side,
		i_dirt.."^[resize:16x16^[combine:16x16:0,0="..i_grass_side..":8,8="..i_grass_side,
		i_dirt.."^[resize:16x16^[combine:16x16:0,0="..i_grass_side..":-8,8="..i_grass_side,
		i_dirt.."^[resize:16x16^[combine:16x16:0,0="..i_grass_side..":0,8="..i_grass_side,
	}
	stairs.register_stair_outer(
		subname, recipeitem, groups, faces, description, sounds, worldaligntex
	)


	-- under node stuff. for looking pretty :3
	if grass_node and dirt_node then
		local under_node_name = "grass_slabs:under_stair_outer_"..subname
		local function after_place_node(pos, placer, itemstack, pointed_thing)
			local me = core.get_node(pos)
			local below = core.get_node(pos:offset(0,-1,0))
			if below.name == grass_node or below.name == dirt_node then
				below.name = under_node_name
				below.param2 = me.param2
				core.swap_node(pos:offset(0,-1,0), below)
			end
		end
		local function after_dig_node(pos, oldnode, oldmetadata, digger)
			local below = core.get_node(pos:offset(0,-1,0))
			if below.name == under_node_name then
				below.name = dirt_node
				core.swap_node(pos:offset(0,-1,0), below)
			end
		end
		core.override_item("stairs:stair_outer_" .. subname, {
			after_place_node = after_place_node,
			after_dig_node = after_dig_node,
		}, {})
		core.register_node(under_node_name, {
			description = "Dirt Under "..description,
			tiles = {
				i_dirt,
				i_dirt,
				"[combine:16x16:0,0="..i_dirt..":0,-8="..i_grass_side,
				"[combine:16x16:0,0="..i_dirt..":8,-8="..i_grass_side,
				"[combine:16x16:0,0="..i_dirt..":-8,-8="..i_grass_side,
				"[combine:16x16:0,0="..i_dirt..":0,-8="..i_grass_side,
			},
			groups = {crumbly = 3,not_in_creative_inventory = 1},
			drop = "default:dirt",
			sounds = sounds,
			paramtype2 = "facedir"
		})
	end
end


function grass_stairs.register_stair_inner(subname, recipeitem, groups, i_grass,i_dirt,i_grass_side, description,
	sounds, worldaligntex,grass_node,dirt_node)
	local faces = {
		i_grass,
		i_dirt,
		i_dirt.."^[resize:16x16^[combine:16x16:0,0="..i_grass_side..":-8,8="..i_grass_side,
		i_dirt.."^"..i_grass_side,
		i_dirt.."^"..i_grass_side,
		i_dirt.."^[resize:16x16^[combine:16x16:0,0="..i_grass_side..":8,8="..i_grass_side,
	}
	stairs.register_stair_inner(
		subname, recipeitem, groups, faces, description, sounds, worldaligntex
	)


	-- under node stuff. for looking pretty :3
	if grass_node and dirt_node then
		local under_node_name = "grass_slabs:under_stair_inner_"..subname
		local function after_place_node(pos, placer, itemstack, pointed_thing)
			local me = core.get_node(pos)
			local below = core.get_node(pos:offset(0,-1,0))
			if below.name == grass_node or below.name == dirt_node then
				below.name = under_node_name
				below.param2 = me.param2
				core.swap_node(pos:offset(0,-1,0), below)
			end
		end
		local function after_dig_node(pos, oldnode, oldmetadata, digger)
			local below = core.get_node(pos:offset(0,-1,0))
			if below.name == under_node_name then
				below.name = dirt_node
				core.swap_node(pos:offset(0,-1,0), below)
			end
		end
		core.override_item("stairs:stair_inner_" .. subname, {
			after_place_node = after_place_node,
			after_dig_node = after_dig_node,
		}, {})
		core.register_node(under_node_name, {
			description = "Dirt Under "..description,
			tiles = {
				i_dirt,
				i_dirt,
				"[combine:16x16:0,0="..i_dirt..":-8,-8="..i_grass_side,
				i_dirt,
				i_dirt,
				"[combine:16x16:0,0="..i_dirt..":8,-8="..i_grass_side,
			},
			groups = {crumbly = 3,not_in_creative_inventory = 1},
			drop = "default:dirt",
			sounds = sounds,
			paramtype2 = "facedir"
		})
	end
end

function grass_stairs.register_all(subname, recipeitem, groups, i_grass,i_dirt,i_grass_side, description,
	sounds, worldaligntex,grass_node,dirt_node)
	grass_stairs.register_slab(
		subname,recipeitem,groups,i_grass,i_dirt,i_grass_side,
		description.." Slab",sounds,worldaligntex,grass_node,dirt_node
	)
	grass_stairs.register_stair(
		subname,recipeitem,groups,i_grass,i_dirt,i_grass_side,
		description.." Stair",sounds,worldaligntex,grass_node,dirt_node
	)
	grass_stairs.register_stair_outer(
		subname,recipeitem,groups,i_grass,i_dirt,i_grass_side,
		description.." Stair",sounds,worldaligntex,grass_node,dirt_node
	)
	grass_stairs.register_stair_inner(
		subname,recipeitem,groups,i_grass,i_dirt,i_grass_side,
		description.." Stair",sounds,worldaligntex,grass_node,dirt_node
	)
end

function grass_stairs.register_connected(subname, recipeitem, groups, i_grass, description, sounds, make_stairs)
	core.register_node("grass_slabs:connected_"..subname, {
		description = "Connected "..description,
		tiles = {i_grass},
		groups = {crumbly = 3},
		drop = "default:dirt",
		sounds = sounds
	})
	core.register_craft({
		output = "grass_slabs:connected_"..subname,
		recipe = {
			{recipeitem, recipeitem},
			{recipeitem, recipeitem},
		},
	})
	if make_stairs then
		stairs.register_stair_and_slab(
			"connected_"..subname,"grass_slabs:connected_"..subname,groups,{i_grass},
			"Connected "..description.." Stair","Connected "..description.." Slab",sounds,true
		)
		if stairsplus then
			stairsplus:register_slope("moreblocks", subname, "grass_slabs:connected_"..subname, {
				description = "Connected "..description,
				tiles = {i_grass},
				sounds = sounds,
				groups = groups,
			})
		end
	end
end

-- below is registrations.

if default then
	dofile(mypath.."/default_mtg.lua")
end

-- other mod indegrations:

if i3 then
	dofile(mypath.."/i3.lua")
end

if stairsplus and default then
	dofile(mypath.."/moreblocks.lua")
end
