print("Registering hexcol nodes and items.")

hexcol = {hexnodes = {}}

-- sound support
local block_sound = {}

if minetest.get_modpath("default") then
	block_sound = default.node_sound_stone_defaults()
elseif minetest.get_modpath("mcl_sounds") then
	block_sound = mcl_sounds.node_sound_stone_defaults()
end

local nodegroup = {cracky = 1,not_in_creative_inventory = 1}
local itemgroup = {hex = 1}
if not minetest.settings:get_bool("hexcol_inv", true) then
    itemgroup.not_in_creative_inventory = 1
end

function hexcol.register_hexnode(id_prefix,name,tiles,palate_modifier,sounds)
    hexcol.hexnodes[id_prefix] = name
    for i = 0,15,1 
    do 
        local hex = string.format("%x", i)
        minetest.register_node(":hexcol:"..id_prefix..hex.."xx", {
            description = "#"..hex.."xx",
            tiles = tiles,
            sounds = sounds,
            groups = nodegroup,
            paramtype = "light",
            paramtype2 = "color",
            palette = hex.."xx.png"..(palate_modifier or ""),
            sunlight_propagates = true,
            preserve_metadata = function(pos, oldnode, oldmeta, drops)
                local h = hex..string.format("%02x",oldnode.param2)
                drops[1] = ItemStack("hexcol:"..id_prefix..h)
            end,
        })
    end

    for i = 0,4095,1 
    do 
        local hex = string.format("%03x", i)
        local firsthex = string.sub(hex,1,1)
        local p2hex = string.sub(hex,2,3)
        minetest.register_craftitem(":hexcol:"..id_prefix..hex, {
            description = name.."#"..hex,
            inventory_image = tiles[1] or "white.png",
            color = "#"..hex,
            groups = itemgroup,
            sounds = block_sound,
            node_placement_prediction = "hexcol:"..id_prefix..firsthex.."xx",
            place_param2 = tonumber("0x"..p2hex),
            on_place = function(itemstack, placer, pointed_thing)
                if not (creative and creative.is_enabled_for
                and creative.is_enabled_for(placer:get_player_name()))
                then
                    itemstack:take_item(1)
                end
                local node = ItemStack("hexcol:"..id_prefix..firsthex.."xx")
                local param2 = tonumber("0x"..p2hex)
                local _, placed = minetest.item_place(node, placer, pointed_thing, param2)
                return placed and itemstack
            end,
        })
    end
end

hexcol.register_hexnode("","",{"white.png"},"",block_sound)

print("Done.")
