pv_api = {}

-- can player see other_player? other mods override. otherwise always true.
function pv_api.is_visible(observing,observed)
    return true
end

function pv_api.refresh_observers()
    local current = core.get_connected_players()
    for _ind, observed_obj in ipairs(current) do
        local observed_name = observed_obj:get_player_name()
        local obs = {}
        for _ind2, observing_obj in ipairs(current) do
            local observing_name = observing_obj:get_player_name()
            if pv_api.is_visible(observing_name,observed_name) or observing_name == observed_name then --always can observe one's self
                obs[observing_name] = true
            end
        end
        observed_obj:set_observers(obs)
    end
end

minetest.register_globalstep(pv_api.refresh_observers)
