local METADATA_STATE_SAVE_KEY = "mm_visibility"



core.register_privilege("mm_visibility_control", {
    description = "Allows players to toggle their visibility on minimap",
    give_to_singleplayer = false,
    give_to_server_admin = false
})

core.register_privilege("mm_full_visibility_control", {
    description = "Allows players to toggle their and other players' visibility on minimap",
    give_to_singleplayer = false,
    give_to_server_admin = true
})



local function set_player_visibility_on_minimap(player, visibility)
    player:set_properties({
        show_on_minimap = visibility
    })
    if visibility then
        player:get_meta():set_int(METADATA_STATE_SAVE_KEY, 1)
    else
        player:get_meta():set_int(METADATA_STATE_SAVE_KEY, 0)
    end
end

local function can_change_visibility_of(changer_name, second_player_name)
    if changer_name == second_player_name then
        local has_mm_visibility_control_priv = core.check_player_privs(changer_name, {mm_visibility_control = true})
        if has_mm_visibility_control_priv then return true end

        local has_mm_full_visibility_control_priv = core.check_player_privs(changer_name, {mm_full_visibility_control = true})
        if has_mm_full_visibility_control_priv then
            return true
        else
            return false, "You need to have \"mm_visibility_control\" or \"mm_full_visibility_control\" privilege to change your visibility on minimap"
        end
    else
        local has_mm_full_visibility_control_priv = core.check_player_privs(changer_name, {mm_full_visibility_control = true})

        if not has_mm_full_visibility_control_priv then
            return false, "You need to have \"mm_full_visibility_control\" privilege to change other players' visibility on minimap"
        else
            local second_player = core.get_player_by_name(second_player_name)

            if not second_player then
                return false, "Can't find player \""..second_player_name.."\""
            else
                return true
            end
        end
    end
end



core.register_on_joinplayer(function(player, last_login)
    local player_metadata = player:get_meta()

    if player_metadata:contains(METADATA_STATE_SAVE_KEY) then
        if player_metadata:get_int(METADATA_STATE_SAVE_KEY) == 1 then
            set_player_visibility_on_minimap(player, true)
        else
            set_player_visibility_on_minimap(player, false)
        end
    end
end)



core.register_chatcommand("mmhideme", {
    description = "Hides player (which uses this command) from minimap",
    func = function(name, param)
        local can_change, error_msg = can_change_visibility_of(name, name)

        if can_change then
            set_player_visibility_on_minimap(core.get_player_by_name(name), false)

            return true, "Now you should be invisible on minimap"
        else
            return false, error_msg
        end
    end
})

core.register_chatcommand("mmshowme", {
    description = "Shows player (which uses this command) on minimap",
    func = function(name, param)
        local can_change, error_msg = can_change_visibility_of(name, name)

        if can_change then
            set_player_visibility_on_minimap(core.get_player_by_name(name), true)

            return true, "Now you should be visible on minimap"
        else
            return false, error_msg
        end
    end
})

core.register_chatcommand("mmhide", {
    description = "Hides player from minimap",
    params = "<player's name>",
    func = function(name, param)
        local can_change, error_msg = can_change_visibility_of(name, param)

        if can_change then
            local player = core.get_player_by_name(param)
            set_player_visibility_on_minimap(player, false)

            return true, "Now "..param.." should be invisible on minimap"
        else
            return false, error_msg
        end
    end
})

core.register_chatcommand("mmshow", {
    description = "Shows player on minimap",
    params = "<player's name>",
    func = function(name, param)
        local can_change, error_msg = can_change_visibility_of(name, param)

        if can_change then
            local player = core.get_player_by_name(param)
            set_player_visibility_on_minimap(player, true)

            return true, "Now "..param.." should be visible on minimap"
        else
            return false, error_msg
        end
    end
})