local modname = "extruder"
extruder = {}

-- TODO look into integrating with stuff like worldedit undo

-- Get the four unit vectors parallel to axes that are perpendicular to a given one (also parallel to an axis)
local function get_perpendiculars(vec)
  if vec.x ~= 0 then
    return {
      vector.new(0,  1,  0),
      vector.new(0, -1,  0),
      vector.new(0,  0,  1),
      vector.new(0,  0, -1),
    }
  end
  if vec.y ~= 0 then
    return {
      vector.new( 1, 0,  0),
      vector.new(-1, 0,  0),
      vector.new( 0, 0,  1),
      vector.new( 0, 0, -1),
    }
  end
  -- if vec.z ~= 0 then
  return {
    vector.new( 1,  0, 0),
    vector.new(-1,  0, 0),
    vector.new( 0,  1, 0),
    vector.new( 0, -1, 0),
  }
end

local function visit_wrapped(visited, to_visit, direction, perpendiculars)
  local pos = table.remove(to_visit)
  while pos do
    if visited[vector.to_string(pos)] == nil then
      local above = vector.add(pos, direction)
      local node = minetest.get_node(pos)
      local node_above = minetest.get_node(above)
      if node.name == "air" or node.name == "ignore" or node_above.name ~= "air" then
        visited[vector.to_string(pos)] = false
      else
        visited[vector.to_string(pos)] = node
        for _,visit_direction in pairs(perpendiculars) do
          table.insert(to_visit, vector.add(pos, visit_direction))
        end
      end
    end
    pos = table.remove(to_visit)
  end
end

local function visit(pos, direction)
  local visited = {}
  visit_wrapped(visited, {pos}, direction, get_perpendiculars(direction))
  return visited
end

local function extrude(surface, direction)
  -- TODO use VoxelManip (and accumulate two of the bounding coordinates in visit()?)
  -- or at least bulk_set_node
  for pos_str,node in pairs(surface) do
    if node then
      local pos = vector.from_string(pos_str)
      minetest.set_node(vector.add(pos, direction), node)
    end
  end
end

minetest.register_tool(modname .. ":extruder", {
    description = "Extruder tool\nClick to extrude a surface, right click to adjust options",
    inventory_image = "extruder.png",
    stack_max = 1,
    liquids_pointable = true,
    -- MAYBE switch to on_place since a node should be pointed?
    on_use = function(_, placer, pointed_thing)
      if placer == nil or pointed_thing == nil then return end
      -- TODO check for permissions
      if pointed_thing.type == "node" then
        local direction = vector.direction(pointed_thing.under, pointed_thing.above)
        local surface = visit(pointed_thing.under, direction)
        -- TODO ask for confirmation if surface is too big (block limit field/checkbox in formspec?)
        -- confirmation can be "click again" (store previous above and under)
        extrude(surface, direction)
      end
    end,

    -- TODO add formspec with "amount" field and "go/select through vertices" checkbox
    --on_secondary_use = function(itemstack, placer, pointed_thing)
    --end,
})
