local http, instance, key

function fediauth.send_code(code, account_handle)
	local status = {
		visibility = "direct",
		status = "" .. code .. " " .. account_handle .. " code for minetest fediauth, do not share it!"
	}
	local json = minetest.write_json(status)
	http.fetch({
		url = "https://" .. instance .. "/api/v1/statuses",
		extra_headers = { "Content-Type: application/json", "Authorization: Bearer " .. key },
		timeout = 15,
		post_data = json
	}, function(res)
		if res then
			minetest.log("action", "[fediauth] code sent to: '" .. account_handle .. "'")
		else
			minetest.log("error", "[fediauth] code not sent to: '" .. account_handle .. "'")
		end
	end)
end

function mastoapi_init(h, i, k)
	http = h
	instance = i
	key = k
end
