
# FediAuth mod for minetest

2FA via Fediverse account, based on https://content.minetest.net/packages/mt-mods/otp/

# Overview

Lets Fediverse players use the `/fediauth_on` command to protect their account with a second factor.

Players that have the FediAuth enabled have to enter a verification code upon joining the game, the code will be sent to their account handle (@nick@example.com).

That mod requires add to `secure.http_mods = fediauth` for sending codes from service account (any mastodon API compatible instance)

Add `fediauth.instance = example.com` and `fediauth.api_token = secret` for work this mod.

Also you can enable fediauth.fedi_required option and players who not have fediverse account can't play on server

# Screenshots

FediAuth verification form
![](./screenshot1.jpg)

FediAuth Setup form
![](./screenshot2.jpg)

FediAuth checkmark if verified success
![](./screenshot3.jpg)


# Temporary privilege revocation

All of the privileges get revoked when logging in with the fediauth enabled (until the proper code is entered).
Some exceptions:
* `fly` (otherwise the player would literally fall from the sky)
* `noclip`

To disable revokation on custom privs the field `fediauth_keep` can be set to true on the definition:
```lua
minetest.register_privilege("my_super_important_priv", {
    description = "something something",
    fediauth_keep = true
})
```

# Links / References

* https://fedi.tips/
* https://en.wikipedia.org/wiki/Time-based_one-time_password
* https://en.wikipedia.org/wiki/HMAC-based_one-time_password
* https://en.wikipedia.org/wiki/HMAC
* https://github.com/google/google-authenticator/wiki/Key-Uri-Format

# Chatcommands

* `/fediauth_on` Starts the FediAuth
* `/fediauth_off` Disables the FediAuth login

# Privileges

* `fediauth_enabled` Players with this privilege have to verify the Fediverse code upon login (automatically granted on successful `/fediauth_on`)
* `fediauth_bypass` Players with this privilege can bypass verification for any reason, and the privilege can only granted manually by administrator

# License

* Code: `MIT`
* "basexx.lua" `MIT` https://github.com/aiq/basexx/blob/master/lib/basexx.lua

Textures:
* fediverse.png from https://commons.wikimedia.org/wiki/File:Fediverse_logo_proposal.svg by Eukombos, CC0 1.0
* checkmark.png (aka blobfoxcheck.png) from https://volpeon.ink/projects/emojis/blobfox/ by volpeon, Apache 2.0
