local MP = minetest.get_modpath("fediauth")
local http = minetest.request_http_api()

-- sanity checks
assert(type(minetest.encode_png) == "function")

fediauth = {
    -- mod storage
    storage = minetest.get_mod_storage(),

    -- baseXX functions
    basexx = loadfile(MP.."/basexx.lua")(),
}

dofile(MP.."/mastoapi.lua")
local instance = minetest.settings:get("fediauth.instance")
local key = minetest.settings:get("fediauth.api_token")
if not instance or not key then
	minetest.log("warning", "[fediauth] For working fediauth you should specify fediauth.instance and fediauth.api_token")
else
	mastoapi_init(http, instance, key)
	dofile(MP.."/functions.lua")
	dofile(MP.."/onboard.lua")
	dofile(MP.."/join.lua")
	dofile(MP.."/privs.lua")
	dofile(MP.."/priv_revoke.lua")
end

