local http, instance, key
local server_name = minetest.settings:get("server_name") or ""
local automatic_delete = minetest.settings:get_bool("fediauth.automatic_delete")
local S = minetest.get_translator("fediauth")

function fediauth.send_code(code, account_handle, playername)
	local lang_code = minetest.get_player_information(playername).lang_code
	local expires_in = nil
	if automatic_delete then
		expires_in = 3600
	end

	local status = {
		visibility = "direct",
		status = minetest.get_translated_string(lang_code, S("This is an automated message from minetest server ")) .. server_name ..
		minetest.get_translated_string(lang_code, S(" If you did not request this message please ignore or block. Your requested one-time code is:\n\n")) .. 
		code .. 
		"\n\n" ..
		account_handle,
		expires_in = expires_in
	}
	local json = minetest.write_json(status)
	http.fetch({
		url = "https://" .. instance .. "/api/v1/statuses",
		extra_headers = { "Content-Type: application/json", "Authorization: Bearer " .. key },
		timeout = 15,
		post_data = json
	}, function(res)
		if res.code == 200 then
			minetest.log("action", "[fediauth] code sent to: '" .. account_handle .. "' for player " .. playername)
		else
			minetest.log("error", "[fediauth] code not sent to: '" .. account_handle .. "' for player " .. playername)
		end
	end)
end

function mastoapi_init(h, i, k)
	http = h
	instance = i
	key = k
end
