local mod_name = core.get_current_modname()

local function show_formspec(player_ref)

    local player_name = player_ref:get_player_name()

    local stats_list = atl_server_statistics.statistics
    local formspec = 
    atl_server_statistics.create_base_formspec(stats_list, 1, player_name)
    formspec = formspec .. 
    atl_server_statistics.generate_stats_table(stats_list[1], player_name)
    core.show_formspec(player_name, "leaderboard:form", formspec)

    if atl_server_statistics.is_player_online(player_name) then
        atl_server_statistics.update_playtime_on_stats(player_name)
    end

end

if core.get_modpath("sfinv_buttons") and
core.get_modpath("atl_server_statistics") then
    sfinv_buttons.register_button(mod_name,
    {
        title = "Player Statistics",
        action = show_formspec,
        tooltip = "Show player statistics and leaderboard",
        image = mod_name .. "_icon.png",
    })
end
